/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.data.cosmosdb.repository.support;

import com.microsoft.azure.spring.data.cosmosdb.core.DocumentDbOperations;
import com.microsoft.azure.spring.data.cosmosdb.repository.query.DocumentDbQueryMethod;
import com.microsoft.azure.spring.data.cosmosdb.repository.query.PartTreeDocumentDbQuery;
import com.microsoft.azure.spring.data.cosmosdb.repository.support.DocumentDbEntityInformation;
import com.microsoft.azure.spring.data.cosmosdb.repository.support.SimpleDocumentDbRepository;
import java.lang.reflect.Method;
import java.util.Optional;
import org.springframework.context.ApplicationContext;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.util.Assert;

@Deprecated
public class DocumentDbRepositoryFactory
extends RepositoryFactorySupport {
    private final ApplicationContext applicationContext;
    private final DocumentDbOperations dbOperations;

    public DocumentDbRepositoryFactory(DocumentDbOperations dbOperations, ApplicationContext applicationContext) {
        this.dbOperations = dbOperations;
        this.applicationContext = applicationContext;
    }

    protected Class<?> getRepositoryBaseClass(RepositoryMetadata metadata) {
        return SimpleDocumentDbRepository.class;
    }

    protected Object getTargetRepository(RepositoryInformation information) {
        EntityInformation entityInformation = this.getEntityInformation(information.getDomainType());
        return this.getTargetRepositoryViaReflection(information, new Object[]{entityInformation, this.applicationContext});
    }

    public <T, ID> EntityInformation<T, ID> getEntityInformation(Class<T> domainClass) {
        return new DocumentDbEntityInformation(domainClass);
    }

    protected Optional<QueryLookupStrategy> getQueryLookupStrategy(QueryLookupStrategy.Key key, QueryMethodEvaluationContextProvider evaluationContextProvider) {
        return Optional.of(new DocumentDbQueryLookupStrategy(this.dbOperations, evaluationContextProvider));
    }

    private static class DocumentDbQueryLookupStrategy
    implements QueryLookupStrategy {
        private final DocumentDbOperations dbOperations;

        public DocumentDbQueryLookupStrategy(DocumentDbOperations operations, QueryMethodEvaluationContextProvider provider) {
            this.dbOperations = operations;
        }

        public RepositoryQuery resolveQuery(Method method, RepositoryMetadata metadata, ProjectionFactory factory, NamedQueries namedQueries) {
            DocumentDbQueryMethod queryMethod = new DocumentDbQueryMethod(method, metadata, factory);
            Assert.notNull((Object)((Object)queryMethod), (String)"queryMethod must not be null!");
            Assert.notNull((Object)this.dbOperations, (String)"dbOperations must not be null!");
            return new PartTreeDocumentDbQuery(queryMethod, this.dbOperations);
        }
    }
}

