/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.integration.servicebus.converter;

import com.microsoft.azure.servicebus.IMessage;
import com.microsoft.azure.servicebus.Message;
import com.microsoft.azure.spring.integration.core.converter.AbstractAzureMessageConverter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.MessageHeaders;
import org.springframework.util.InvalidMimeTypeException;
import org.springframework.util.MimeType;
import org.springframework.util.StringUtils;

public class ServiceBusMessageConverter
extends AbstractAzureMessageConverter<IMessage> {
    private static final Logger log = LoggerFactory.getLogger(ServiceBusMessageConverter.class);

    protected byte[] getPayload(IMessage azureMessage) {
        return azureMessage.getBody();
    }

    protected IMessage fromString(String payload) {
        return new Message(payload);
    }

    protected IMessage fromByte(byte[] payload) {
        return new Message(payload);
    }

    protected void setCustomHeaders(MessageHeaders headers, IMessage serviceBusMessage) {
        if (headers.containsKey((Object)"contentType")) {
            Object contentType = headers.get((Object)"contentType");
            if (contentType instanceof MimeType) {
                serviceBusMessage.setContentType(((MimeType)contentType).toString());
            } else {
                serviceBusMessage.setContentType((String)contentType);
            }
        }
        if (headers.containsKey((Object)"id")) {
            serviceBusMessage.setMessageId(((UUID)headers.get((Object)"id", UUID.class)).toString());
        }
        if (headers.containsKey((Object)"replyChannel")) {
            serviceBusMessage.setReplyTo((String)headers.get((Object)"replyChannel", String.class));
        }
        headers.entrySet().forEach(e -> serviceBusMessage.getProperties().put((String)e.getKey(), e.getValue().toString()));
    }

    protected Map<String, Object> buildCustomHeaders(IMessage serviceBusMessage) {
        HashMap<String, String> headers = new HashMap<String, String>();
        if (StringUtils.hasText((String)serviceBusMessage.getMessageId())) {
            headers.put("raw_id", serviceBusMessage.getMessageId());
        }
        if (StringUtils.hasText((String)serviceBusMessage.getContentType())) {
            String contentType = serviceBusMessage.getContentType();
            try {
                MimeType mimeType = MimeType.valueOf((String)contentType);
                headers.put("contentType", mimeType.toString());
            }
            catch (InvalidMimeTypeException e) {
                log.warn("Invalid mimeType '{}' from service bus message.", (Object)contentType);
            }
        }
        if (StringUtils.hasText((String)serviceBusMessage.getReplyTo())) {
            headers.put("replyChannel", serviceBusMessage.getReplyTo());
        }
        headers.putAll(serviceBusMessage.getProperties());
        return Collections.unmodifiableMap(headers);
    }
}

