/**************************************************************************
 * copyright file="GetServerTimeZonesRequest.java" company="Microsoft"
 *     Copyright (c) Microsoft Corporation.  All rights reserved.
 * 
 * Defines the GetServerTimeZonesRequest.java.
 **************************************************************************/
package microsoft.exchange.webservices.data;

import javax.xml.stream.XMLStreamException;

/**
 * Represents a GetServerTimeZones request.
 */
class GetServerTimeZonesRequest extends
		MultiResponseServiceRequest<GetServerTimeZonesResponse> {

	/** The ids. */
	private Iterable<String> ids;

	/**
	 * Gets the XML element name associated with the transition.
	 * 
	 * @throws Exception
	 *             the exception
	 */
	@Override
	protected void validate() throws Exception {
		super.validate();
		if (this.ids != null) {
			EwsUtilities.validateParamCollection(this.getIds().iterator(),
					"Ids");
		}
	}

	/**
	 * Initializes a new instance of the "GetServerTimeZonesRequest" class.
	 * 
	 * @param service
	 *            the service
	 * @throws Exception 
	 */
	protected GetServerTimeZonesRequest(ExchangeService service)
			throws Exception {
		super(service, ServiceErrorHandling.ThrowOnError);
	}

	/**
	 * Creates the service response.
	 * 
	 * @param service
	 *            the service
	 * @param responseIndex
	 *            the response index
	 * @return Service response.
	 */
	@Override
	protected GetServerTimeZonesResponse createServiceResponse(
			ExchangeService service, int responseIndex) {
		return new GetServerTimeZonesResponse();
	}

	/**
	 * Gets the name of the response message XML element.
	 * 
	 * @return XML element name,
	 */
	@Override
	protected String getResponseMessageXmlElementName() {
		return XmlElementNames.GetServerTimeZonesResponseMessage;
	}

	/**
	 * Gets the expected response message count.
	 * 
	 * @return Number of expected response messages.
	 */
	@Override
	protected int getExpectedResponseMessageCount() {
		return 1;
	}

	/**
	 * Gets the name of the XML element.
	 * 
	 * @return XML element name,
	 */
	@Override
	protected String getXmlElementName() {
		return XmlElementNames.GetServerTimeZones;
	}

	/**
	 * Gets the name of the response XML element.
	 * 
	 * @return XML element name,
	 */
	@Override
	protected String getResponseXmlElementName() {
		return XmlElementNames.GetServerTimeZonesResponse;
	}

	/**
	 * Gets the minimum server version required to process this request.
	 * 
	 * @return Exchange server version.
	 */
	@Override
	protected ExchangeVersion getMinimumRequiredServerVersion() {
		return ExchangeVersion.Exchange2010;
	}

	/**
	 * Writes XML elements.
	 * 
	 * @param writer
	 *            the writer
	 * @throws ServiceXmlSerializationException
	 *             the service xml serialization exception
	 * @throws XMLStreamException
	 *             the xML stream exception
	 */
	@Override
	protected void writeElementsToXml(EwsServiceXmlWriter writer)
			throws ServiceXmlSerializationException, XMLStreamException {
		if (this.getIds() != null) {
			writer
					.writeStartElement(XmlNamespace.Messages,
							XmlElementNames.Ids);

			for (String id : this.getIds()) {
				writer.writeElementValue(XmlNamespace.Types,
						XmlElementNames.Id, id);
			}

			writer.writeEndElement(); // Ids
		}
	}

	/**
	 * Gets  the ids of the time zones that should be returned by the
	 * server.
	 *
	 * @return the ids
	 */
	protected Iterable<String> getIds() {
		return this.ids;
	}

	/**
	 * Sets the ids.
	 * 
	 * @param ids
	 *            the new ids
	 */
	protected void setIds(Iterable<String> ids) {
		this.ids = ids;
	}
}
