/**************************************************************************
 * copyright file="StartTimeZonePropertyDefinition.java" company="Microsoft"
 *     Copyright (c) Microsoft Corporation.  All rights reserved.
 * 
 * Defines the StartTimeZonePropertyDefinition.java.
 **************************************************************************/
package microsoft.exchange.webservices.data;

import java.util.EnumSet;
import java.util.List;

import javax.xml.stream.XMLStreamException;

/***
 * Represents a property definition for properties of type TimeZoneInfo.
 * 
 * 
 */
class StartTimeZonePropertyDefinition extends TimeZonePropertyDefinition {

	/**
	 * * Initializes a new instance of the StartTimeZonePropertyDefinition
	 * class.
	 * 
	 * @param xmlElementName
	 *            the xml element name
	 * @param uri
	 *            the uri
	 * @param flags
	 *            the flags
	 * @param version
	 *            the version
	 */
	protected StartTimeZonePropertyDefinition(String xmlElementName,
			String uri, EnumSet<PropertyDefinitionFlags> flags,
			ExchangeVersion version) {
		super(xmlElementName, uri, flags, version);
	}

	/**
	 * * Registers associated internal properties.
	 * 
	 * @param properties
	 *            the properties
	 */
	protected void registerAssociatedInternalProperties(
			List<PropertyDefinition> properties) {
		super.registerAssociatedInternalProperties(properties);

		properties.add(AppointmentSchema.MeetingTimeZone);
	}

	/**
	 * * Writes to XML.
	 * 
	 * @param writer
	 *            the writer
	 * @param propertyBag
	 *            the property bag
	 * @param isUpdateOperation
	 *            the is update operation
	 * @throws Exception
	 *             the exception
	 */
	protected void writePropertyValueToXml(EwsServiceXmlWriter writer,
			PropertyBag propertyBag, boolean isUpdateOperation)
			throws Exception {
		Object value = propertyBag.getObjectFromPropertyDefinition(this);

		if (value != null) {
			if (writer.getService().getRequestedServerVersion() == ExchangeVersion.Exchange2007_SP1) {
				ExchangeService service = (ExchangeService)writer.getService() ;
                if (service != null && service.getExchange2007CompatibilityMode() == false)
                {
				MeetingTimeZone meetingTimeZone = new MeetingTimeZone(
						(TimeZoneDefinition)value);
				meetingTimeZone.writeToXml(writer,
						XmlElementNames.MeetingTimeZone);
                }
			}else {
				super.writePropertyValueToXml(writer, propertyBag,
						isUpdateOperation);
			}
		}
	}

	/**
	 * * Writes to XML.
	 * 
	 * @param writer
	 *            the writer
	 * @throws XMLStreamException
	 *             the xML stream exception
	 * @throws ServiceXmlSerializationException
	 *             the service xml serialization exception
	 */
	protected void writeToXml(EwsServiceXmlWriter writer)
			throws XMLStreamException, ServiceXmlSerializationException {
		if (writer.getService().getRequestedServerVersion() == ExchangeVersion.Exchange2007_SP1) {
			AppointmentSchema.MeetingTimeZone.writeToXml(writer);
		} else {
			super.writeToXml(writer);
		}
	}
	
	/**
	 * Determines whether the specified flag is set.
	 * 
	 * @param flag The flag.	
	 * @param version Requested version.
	 * @return <c>true</c> if the specified 
	 * flag is set; otherwise, <c>false</c>.	
	 */	
	@Override
	protected  boolean hasFlag(PropertyDefinitionFlags flag, 
			ExchangeVersion version) {
        if (version!=null && (version == ExchangeVersion.Exchange2007_SP1))
        {
            return AppointmentSchema.MeetingTimeZone.hasFlag(flag, version);
        }
        else
        {
            return super.hasFlag(flag, version);
        }
    }

}
