/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.gctoolkit.aggregator;

import com.microsoft.gctoolkit.aggregator.Aggregates;
import com.microsoft.gctoolkit.aggregator.Aggregation;
import com.microsoft.gctoolkit.aggregator.EventSource;
import com.microsoft.gctoolkit.aggregator.JVMEventDispatcher;
import com.microsoft.gctoolkit.event.jvm.JVMEvent;
import com.microsoft.gctoolkit.event.jvm.JVMTermination;
import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;

public abstract class Aggregator<A extends Aggregation> {
    private final A aggregation;
    private Runnable completionTask;
    private final JVMEventDispatcher jvmEventDispatcher = new JVMEventDispatcher();
    private static final ExecutorService executorService = Executors.newSingleThreadExecutor(runnable -> {
        Thread thread = new Thread(runnable, "aggregator-completion");
        thread.setDaemon(true);
        return thread;
    });

    protected Aggregator(A aggregation) {
        this.aggregation = aggregation;
    }

    public A aggregation() {
        return this.aggregation;
    }

    protected <E extends JVMEvent> void register(Class<E> eventClass, Consumer<? super E> process) {
        this.jvmEventDispatcher.register(eventClass, process);
    }

    public void onCompletion(Runnable task) {
        this.completionTask = task;
    }

    private void complete() {
        if (this.completionTask != null) {
            executorService.execute(this.completionTask);
        }
    }

    public void receive(JVMEvent event) {
        ((Aggregation)this.aggregation()).updateEventFrequency(event);
        if (event instanceof JVMTermination) {
            ((Aggregation)this.aggregation()).timeOfTerminationEvent(((JVMTermination)event).getTimeOfTerminationEvent());
            ((Aggregation)this.aggregation()).timeOfFirstEvent(((JVMTermination)event).getTimeOfFirstEvent());
        }
        this.jvmEventDispatcher.dispatch(event);
        if (event instanceof JVMTermination) {
            this.complete();
        }
    }

    public boolean aggregates(EventSource eventSource) {
        return eventSource != null && this.aggregates(this.getClass(), eventSource);
    }

    private boolean aggregates(Class<?> clazz, EventSource targetEventSource) {
        if (clazz != null && clazz != Aggregator.class) {
            Class<?>[] interfaces;
            Aggregates aggregates;
            if (clazz.isAnnotationPresent(Aggregates.class) && (aggregates = clazz.getAnnotation(Aggregates.class)) != null && Arrays.asList(aggregates.value()).contains((Object)targetEventSource)) {
                return true;
            }
            if (this.aggregates(clazz.getSuperclass(), targetEventSource)) {
                return true;
            }
            for (Class<?> iface : interfaces = clazz.getInterfaces()) {
                if (!this.aggregates(iface, targetEventSource)) continue;
                return true;
            }
        }
        return false;
    }
}

