/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.gctoolkit.io;

import com.microsoft.gctoolkit.io.LogFileSegment;
import com.microsoft.gctoolkit.time.DateTimeStamp;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collector;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class GCLogFileZipSegment
implements LogFileSegment {
    private final Path path;
    private final String segmentName;
    private DateTimeStamp endTime = null;
    private DateTimeStamp startTime = null;

    public GCLogFileZipSegment(Path path, String segmentName) {
        this.path = path;
        this.segmentName = segmentName;
    }

    @Override
    public Path getPath() {
        return this.path;
    }

    @Override
    public String getSegmentName() {
        return this.segmentName;
    }

    private void ageOfJVMAtLogStart() {
        if (this.startTime == null) {
            this.startTime = this.stream().filter(s -> !s.contains(" file created ")).map(DateTimeStamp::fromGCLogLine).filter(dateTimeStamp -> dateTimeStamp.hasTimeStamp() || dateTimeStamp.hasDateStamp()).findFirst().orElse(new DateTimeStamp(-1.0));
        }
    }

    private DateTimeStamp ageOfJVMAtLogEnd() {
        if (this.endTime == null) {
            List tail = this.stream().collect(this.tail(100));
            this.endTime = tail.stream().filter(line -> !line.contains("Saved as")).map(DateTimeStamp::fromGCLogLine).filter(dateTimeStamp -> dateTimeStamp.hasTimeStamp() || dateTimeStamp.hasDateStamp()).max(Comparator.comparing(dateTimeStamp -> dateTimeStamp != null ? dateTimeStamp.getTimeStamp() : 0.0)).orElse(DateTimeStamp.EMPTY_DATE);
        }
        return this.endTime;
    }

    public <T> Collector<T, ?, List<T>> tail(int n) {
        return Collector.of(ArrayDeque::new, (buffer, line) -> {
            if (buffer.size() == n) {
                buffer.pollFirst();
            }
            buffer.add(line);
        }, (buffer, list) -> {
            while (list.size() < n && !buffer.isEmpty()) {
                list.addFirst(buffer.pollLast());
            }
            return list;
        }, ArrayList::new, new Collector.Characteristics[0]);
    }

    @Override
    public double getStartTime() {
        try {
            this.ageOfJVMAtLogStart();
            if (this.startTime.hasTimeStamp()) {
                return this.startTime.getTimeStamp();
            }
            if (this.startTime.hasDateStamp()) {
                return this.startTime.toEpochInMillis();
            }
            return Double.MAX_VALUE;
        }
        catch (NullPointerException ex) {
            return Double.MIN_VALUE;
        }
    }

    @Override
    public double getEndTime() {
        try {
            this.ageOfJVMAtLogEnd();
            if (this.endTime.hasTimeStamp()) {
                return this.endTime.getTimeStamp();
            }
            if (this.endTime.hasDateStamp()) {
                return this.endTime.toEpochInMillis();
            }
            return Double.MAX_VALUE;
        }
        catch (NullPointerException ex) {
            return Double.MIN_VALUE;
        }
    }

    @Override
    public Stream<String> stream() {
        try {
            ZipFile file = new ZipFile(this.path.toFile());
            ZipEntry entry = file.getEntry(this.segmentName);
            return new BufferedReader(new InputStreamReader(file.getInputStream(entry))).lines();
        }
        catch (IOException e) {
            e.printStackTrace();
            return new ArrayList().stream();
        }
    }

    public String toString() {
        return this.getSegmentName();
    }
}

