/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.gctoolkit.parser;

import com.microsoft.gctoolkit.GCToolKit;
import com.microsoft.gctoolkit.event.GCCause;
import com.microsoft.gctoolkit.event.GCCauses;
import com.microsoft.gctoolkit.event.MemoryPoolSummary;
import com.microsoft.gctoolkit.event.RegionSummary;
import com.microsoft.gctoolkit.event.UnifiedCountSummary;
import com.microsoft.gctoolkit.event.UnifiedStatisticalSummary;
import com.microsoft.gctoolkit.event.jvm.MetaspaceRecord;
import com.microsoft.gctoolkit.event.jvm.PermGenSummary;
import com.microsoft.gctoolkit.event.zgc.ZGCPhase;
import com.microsoft.gctoolkit.parser.AbstractLogTrace;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;

public class GCLogTrace
extends AbstractLogTrace {
    private static final Logger LOGGER = Logger.getLogger(GCLogTrace.class.getName());
    private final boolean gcCauseDebugging = Boolean.getBoolean("microsoft.debug.gccause");

    public GCLogTrace(Matcher matcher) {
        super(matcher);
    }

    @Override
    public int groupCount() {
        return this.trace.groupCount();
    }

    @Override
    public boolean groupNotNull(int index) {
        return this.getGroup(index) != null;
    }

    @Override
    public long getLongGroup(int index) {
        return Long.parseLong(this.trace.group(index));
    }

    @Override
    public int getIntegerGroup(int index) {
        return Integer.parseInt(this.trace.group(index));
    }

    public GCCause gcCause(int base, int offset) {
        if (this.gcCauseDebugging && this.getGroup(base + offset) != null) {
            LOGGER.fine("GC cause: " + this.getGroup(base + offset));
            this.notYetImplemented();
        }
        return GCCauses.get((String)this.getGroup(base + offset));
    }

    public GCCause gcCause(int offset) {
        return this.gcCause(6, offset);
    }

    public GCCause gcCause() {
        return this.gcCause(6, 0);
    }

    public double getPauseTime() {
        return this.getDoubleGroup(this.groupCount());
    }

    public double getDuration() {
        return this.getDoubleGroup(this.groupCount());
    }

    public double getDurationInSeconds() {
        return this.getDuration() / 1000.0;
    }

    public double getMilliseconds(int index) {
        return this.getDoubleGroup(index);
    }

    public double getSeconds(int index) {
        return this.getDoubleGroup(index);
    }

    public double getMilliseconds() {
        return this.getMilliseconds(this.groupCount());
    }

    public boolean contains(int index, String value) {
        String text = this.getGroup(index);
        if (text != null) {
            return text.contains(value);
        }
        return false;
    }

    public boolean contains(String value) {
        return this.trace.group(0).contains(value);
    }

    public String toString() {
        return this.trace.group(0);
    }

    public boolean hasNext() {
        return this.trace.find();
    }

    public int end() {
        return this.trace.end();
    }

    public long toKBytes(int offset) {
        return this.toKBytes(this.getLongGroup(offset), this.getGroup(offset + 1));
    }

    public long doubleToKBytes(int offset) {
        return (long)this.toKBytes(this.getDoubleGroup(offset), this.getGroup(offset + 1));
    }

    private double toKBytes(double value, String units) {
        double returnValue = value;
        switch (Character.toUpperCase(units.codePointAt(0))) {
            case 71: {
                returnValue *= 1024.0;
            }
            case 77: {
                returnValue *= 1024.0;
            }
            case 75: {
                break;
            }
            case 66: {
                returnValue /= 1024.0;
                break;
            }
            default: {
                LOGGER.log(Level.WARNING, "Invalid unit [B,K,M,G] {0}", units);
            }
        }
        return returnValue;
    }

    public long toKBytes(long value, String units) {
        long returnValue = value;
        switch (Character.toUpperCase(units.codePointAt(0))) {
            case 71: {
                returnValue *= 1024L;
            }
            case 77: {
                returnValue *= 1024L;
            }
            case 75: {
                break;
            }
            case 66: {
                returnValue /= 1024L;
                break;
            }
            default: {
                LOGGER.log(Level.WARNING, "Invalid unit [B,K,M,G] {0}", units);
            }
        }
        return returnValue;
    }

    public PermGenSummary getMetaspaceSummary(int offset) {
        try {
            long before = this.toKBytes(offset);
            long after = this.toKBytes(offset + 2);
            long size = this.toKBytes(offset + 4);
            return new PermGenSummary(before, after, size);
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.fine("Unable to calculate Metaspace summary.");
            this.notYetImplemented();
            return null;
        }
    }

    public MemoryPoolSummary getOccupancyBeforeAfterWithMemoryPoolSizeSummary(int offset) {
        try {
            long before = this.toKBytes(offset);
            long after = this.toKBytes(offset + 2);
            long size = this.toKBytes(offset + 4);
            return new MemoryPoolSummary(before, size, after, size);
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warning("Unable to calculate generational memory pool summary.");
            this.notYetImplemented();
            return null;
        }
    }

    public MemoryPoolSummary getOccupancyWithMemoryPoolSizeSummary(int offset) {
        try {
            long occupancy = this.toKBytes(offset);
            long size = this.toKBytes(offset + 2);
            return new MemoryPoolSummary(occupancy, size, occupancy, size);
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.fine("Unable to calculate generational memory pool occupancy summary.");
            this.notYetImplemented();
            return null;
        }
    }

    public MemoryPoolSummary getOccupancyWithMemoryPoolSizeSummary() {
        try {
            long occupancy = this.toKBytes(1);
            long size = this.toKBytes(3);
            return new MemoryPoolSummary(occupancy, size, occupancy, size);
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.fine("Unable to calculate generational memory pool occupancy summary.");
            this.notYetImplemented();
            return null;
        }
    }

    public MetaspaceRecord getMetaSpaceRecord(int offset) {
        try {
            long before = this.toKBytes(offset);
            long after = this.toKBytes(offset + 2);
            long size = this.toKBytes(offset + 4);
            return new MetaspaceRecord(before, after, size);
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.fine("Unable to calculate Metaspace summary.");
            this.notYetImplemented();
            return null;
        }
    }

    public MetaspaceRecord getEnlargedMemoryPoolRecord(int offset) {
        try {
            long before = this.toKBytes(offset);
            long after = this.toKBytes(offset + 4);
            long size = this.toKBytes(offset + 6);
            return new MetaspaceRecord(before, after, size);
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.fine("Unable to calculate Metaspace summary.");
            this.notYetImplemented();
            return null;
        }
    }

    public MetaspaceRecord getEnlargedMetaSpaceRecord(int offset) {
        try {
            long before = this.toKBytes(offset);
            long sizeBefore = this.toKBytes(offset + 2);
            long after = this.toKBytes(offset + 4);
            long size = this.toKBytes(offset + 6);
            return new MetaspaceRecord(before, sizeBefore, after, size);
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.fine("Unable to calculate Metaspace summary.");
            this.notYetImplemented();
            return null;
        }
    }

    public UnifiedStatisticalSummary getUnifiedStatisticalSummary() {
        return new UnifiedStatisticalSummary(this.getDoubleGroup(2), this.getDoubleGroup(3), this.getDoubleGroup(4), this.getDoubleGroup(5), this.getDoubleGroup(6), this.getIntegerGroup(7));
    }

    public UnifiedCountSummary countSummary() {
        return new UnifiedCountSummary(this.getIntegerGroup(2), this.getDoubleGroup(3), this.getIntegerGroup(4), this.getIntegerGroup(5), this.getIntegerGroup(6), this.getIntegerGroup(7));
    }

    public RegionSummary regionSummary() {
        return new RegionSummary(this.getIntegerGroup(2), this.getIntegerGroup(3), this.trace.group(4) != null ? this.getIntegerGroup(4) : this.getIntegerGroup(3));
    }

    public void notYetImplemented() {
        String threadName = Thread.currentThread().getName();
        LOGGER.log(Level.FINE, "{0}, not implemented: {1}", new Object[]{threadName, this.getGroup(0)});
        for (int i = 1; i < this.groupCount() + 1; ++i) {
            LOGGER.log(Level.FINE, "{0} : {1}", new Object[]{i, this.getGroup(i)});
        }
        LOGGER.fine("-----------------------------------------");
        GCToolKit.LOG_DEBUG_MESSAGE(() -> {
            StringBuilder debugMessage = new StringBuilder();
            debugMessage.append(threadName).append(", not implemented: ").append(this.getGroup(0)).append(System.lineSeparator());
            for (int i = 1; i < this.groupCount() + 1; ++i) {
                debugMessage.append(i).append(": ").append(this.getGroup(i)).append(System.lineSeparator());
            }
            debugMessage.append("-----------------------------------------");
            return debugMessage.toString();
        });
    }

    public ZGCPhase getZCollectionPhase() {
        return ZGCPhase.get((String)this.getGroup(1));
    }
}

