/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.gctoolkit.parser;

import com.microsoft.gctoolkit.event.generational.CMSRemark;
import com.microsoft.gctoolkit.parser.CMSPatterns;
import com.microsoft.gctoolkit.parser.GCLogParser;
import com.microsoft.gctoolkit.parser.GCLogTrace;
import com.microsoft.gctoolkit.parser.GCParseRule;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class PreUnifiedGCLogParser
extends GCLogParser {
    private static final Logger LOGGER = Logger.getLogger(PreUnifiedGCLogParser.class.getName());
    private final GCParseRule TIMESTAMP_BLOCK = new GCParseRule("TIMESTAMP_BLOCK", "^((\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}\\.\\d{3}[+|-]\\d{4}): (\\d+(?:\\.|,)\\d{3}): |(\\d+(?:\\.|,)\\d{3}): |(\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}\\.\\d{3}[+|-]\\d{4}): )");

    @Override
    void advanceClock(String record) {
        try {
            GCLogTrace trace = this.TIMESTAMP_BLOCK.parse(record);
            if (trace == null && (trace = CMSPatterns.ABORT_PRECLEAN_DUE_TO_TIME_CLAUSE.parse(record)) == null) {
                return;
            }
            super.advanceClock(trace.getDateTimeStamp());
        }
        catch (Throwable t) {
            LOGGER.log(Level.FINE, "[PARSING ERROR] " + record, t);
        }
    }

    void recordRescanStepTimes(CMSRemark collection, String line) {
        double unloading = 0.0;
        double symbolTable = 0.0;
        double stringTable = 0.0;
        double stringAndSymbolTable = 0.0;
        GCLogTrace clause = CLASS_UNLOADING.parse(line);
        if (clause != null) {
            unloading = clause.getDoubleGroup(6);
        }
        if ((clause = SYMBOL_TABLE_SCRUB.parse(line)) != null) {
            symbolTable = clause.getDoubleGroup(6);
        }
        if ((clause = STRING_TABLE_SCRUB.parse(line)) != null) {
            stringTable = clause.getDoubleGroup(6);
        }
        if ((clause = STRING_AND_SYMBOL_SCRUB.parse(line)) != null) {
            stringAndSymbolTable = clause.getDoubleGroup(6);
        }
        collection.addClassUnloadingAndStringTableProcessingDurations(unloading, symbolTable, stringTable, stringAndSymbolTable);
    }
}

