/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.gctoolkit.parser.jvm;

import com.microsoft.gctoolkit.event.GCCause;
import com.microsoft.gctoolkit.event.GCCauses;
import com.microsoft.gctoolkit.jvm.Diarizer;
import com.microsoft.gctoolkit.jvm.Diary;
import com.microsoft.gctoolkit.jvm.SupportedFlags;
import com.microsoft.gctoolkit.parser.CMSPatterns;
import com.microsoft.gctoolkit.parser.G1GCPatterns;
import com.microsoft.gctoolkit.parser.GCLogTrace;
import com.microsoft.gctoolkit.parser.GCParseRule;
import com.microsoft.gctoolkit.parser.JVMPatterns;
import com.microsoft.gctoolkit.parser.ParallelPatterns;
import com.microsoft.gctoolkit.parser.PreUnifiedTokens;
import com.microsoft.gctoolkit.parser.SerialPatterns;
import com.microsoft.gctoolkit.parser.SharedPatterns;
import com.microsoft.gctoolkit.parser.SimplePatterns;
import com.microsoft.gctoolkit.parser.TenuredPatterns;
import com.microsoft.gctoolkit.parser.jvm.CommandLineFlag;
import com.microsoft.gctoolkit.parser.jvm.GarbageCollectorFlag;
import com.microsoft.gctoolkit.time.DateTimeStamp;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PreUnifiedDiarizer
implements Diarizer {
    private static final Logger LOGGER = Logger.getLogger(PreUnifiedDiarizer.class.getName());
    private int lineCount = 10000;
    private static final GCParseRule TENURED_BLOCK = new GCParseRule("TENURED_BLOCK", "\\[Tenured: \\d+K->\\d+K\\(\\d+K\\), \\d+[.|,]\\d{7} secs\\]");
    private static final GCParseRule PREFIX = new GCParseRule("PREFIX", "((\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}\\.\\d{3}[+|-]\\d{4}): (\\d+(?:\\.|,)\\d{3}): |(\\d+(?:\\.|,)\\d{3}): |(\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}\\.\\d{3}[+|-]\\d{4}): )(?:#\\\\d+: )?\\[GC ?(\\([G1,A-Z,a-z, ,-,.gc\\(\\)]+\\))?\\s*");
    private static final GCParseRule FULL_PREFIX = new GCParseRule("FULL_PREFIX", "((\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}\\.\\d{3}[+|-]\\d{4}): (\\d+(?:\\.|,)\\d{3}): |(\\d+(?:\\.|,)\\d{3}): |(\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}\\.\\d{3}[+|-]\\d{4}): )(?:#\\\\d+: )?\\[Full GC ?(\\([G1,A-Z,a-z, ,-,.gc\\(\\)]+\\))?\\s*");
    private static final GCParseRule G1GC_PREFIX = new GCParseRule("G1GC_PREFIX", "^((\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}\\.\\d{3}[+|-]\\d{4}): (\\d+(?:\\.|,)\\d{3}): |(\\d+(?:\\.|,)\\d{3}): |(\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}\\.\\d{3}[+|-]\\d{4}): )\\[GC pause (\\([G1,A-Z,a-z, ,-,.gc\\(\\)]+\\))?\\s*");
    private static final GCParseRule REFERENCE_PROCESSING_BLOCK = new GCParseRule("REFERENCE_PROCESSING_BLOCK", "((\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}\\.\\d{3}[+|-]\\d{4}): (\\d+(?:\\.|,)\\d{3}): |(\\d+(?:\\.|,)\\d{3}): |(\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}\\.\\d{3}[+|-]\\d{4}): )\\[(Soft|Weak|Final)Reference, (\\d+) refs, (-?\\d+(?:\\.|,)\\d+)\\s?(?:secs?|ms|s)\\]((\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}\\.\\d{3}[+|-]\\d{4}): (\\d+(?:\\.|,)\\d{3}): |(\\d+(?:\\.|,)\\d{3}): |(\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}\\.\\d{3}[+|-]\\d{4}): )\\[(Soft|Weak|Final)Reference, (\\d+) refs, (-?\\d+(?:\\.|,)\\d+)\\s?(?:secs?|ms|s)\\]((\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}\\.\\d{3}[+|-]\\d{4}): (\\d+(?:\\.|,)\\d{3}): |(\\d+(?:\\.|,)\\d{3}): |(\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}\\.\\d{3}[+|-]\\d{4}): )\\[(Soft|Weak|Final)Reference, (\\d+) refs, (-?\\d+(?:\\.|,)\\d+)\\s?(?:secs?|ms|s)\\]((\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}\\.\\d{3}[+|-]\\d{4}): (\\d+(?:\\.|,)\\d{3}): |(\\d+(?:\\.|,)\\d{3}): |(\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}\\.\\d{3}[+|-]\\d{4}): )\\[PhantomReference, (\\d+) refs, (?:(\\d+) refs, )?(-?\\d+(?:\\.|,)\\d+)\\s?(?:secs?|ms|s)\\]((\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}\\.\\d{3}[+|-]\\d{4}): (\\d+(?:\\.|,)\\d{3}): |(\\d+(?:\\.|,)\\d{3}): |(\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}\\.\\d{3}[+|-]\\d{4}): )\\[JNI Weak Reference, (?:(\\d+) refs, )?(-?\\d+(?:\\.|,)\\d+)\\s?(?:secs?|ms|s)\\]");
    private static final Pattern excludeG1Ergonomics = Pattern.compile("^\\d+(\\.|,)\\d+: \\[G1Ergonomics");
    private final Diary diary = new Diary();
    private boolean firstCMSCycle = false;
    private int youngCountAfterFirstCMSCycle = 0;
    private int collectionCount = 0;
    private int youngCollectionCount = 0;
    private int tenuringSummary = 0;
    private boolean ageTableDetected = false;
    private int maxTenuringThreshold = 15;
    private int setGCFlags = 0;
    private DateTimeStamp timeOfFirstEvent = null;
    private boolean simpleParallelOrParNewDetected;
    private boolean simpleFullGCDetected;
    private boolean simpleCMSCycleDetected;
    private static final Pattern VERSION = Pattern.compile("(1)\\.([6-9])\\.0(_\\d*)?");

    public PreUnifiedDiarizer() {
        this.diary.setFalse(new SupportedFlags[]{SupportedFlags.UNIFIED_LOGGING, SupportedFlags.ZGC, SupportedFlags.SHENANDOAH});
        this.simpleParallelOrParNewDetected = false;
        this.simpleFullGCDetected = false;
        this.simpleCMSCycleDetected = false;
    }

    public Diary getDiary() {
        this.fillInKnowns();
        return this.diary;
    }

    public boolean isUnified() {
        return false;
    }

    public String getCommandLine() {
        return "";
    }

    public int getMaxTenuringThreshold() {
        return this.maxTenuringThreshold;
    }

    public boolean hasJVMEvents() {
        return this.diary.isApplicationStoppedTime() || this.diary.isApplicationRunningTime() || this.diary.isApplicationRunningTime() || this.diary.isTLABData();
    }

    private boolean versionIsKnown() {
        return this.diary.isStateKnown(SupportedFlags.JDK80) && this.diary.isStateKnown(SupportedFlags.JDK70) && this.diary.isStateKnown(SupportedFlags.PRE_JDK70_40);
    }

    public boolean completed() {
        return this.diary.isComplete() || this.lineCount < 1 || this.simpleCMSCycleDetected && (this.simpleCMSCycleDetected || this.simpleFullGCDetected);
    }

    private void fillInKnowns() {
        if (this.simpleCMSCycleDetected) {
            this.diary.setTrue(SupportedFlags.CMS);
            this.diary.setFalse(new SupportedFlags[]{SupportedFlags.SERIAL, SupportedFlags.PARALLELGC, SupportedFlags.PARALLELOLDGC, SupportedFlags.ICMS, SupportedFlags.G1GC, SupportedFlags.GC_DETAILS, SupportedFlags.TENURING_DISTRIBUTION, SupportedFlags.GC_CAUSE, SupportedFlags.CMS_DEBUG_LEVEL_1, SupportedFlags.ADAPTIVE_SIZING, SupportedFlags.PRINT_HEAP_AT_GC, SupportedFlags.RSET_STATS, SupportedFlags.JDK70, SupportedFlags.PRE_JDK70_40, SupportedFlags.JDK80});
            if (this.youngCollectionCount == 0 || this.ageTableDetected || !this.diary.isTenuringDistribution()) {
                this.diary.setTrue(SupportedFlags.PARNEW);
                this.diary.setFalse(SupportedFlags.DEFNEW);
            } else {
                this.diary.setTrue(SupportedFlags.DEFNEW);
                this.diary.setFalse(SupportedFlags.PARNEW);
            }
        } else if (this.simpleFullGCDetected) {
            if (this.ageTableDetected) {
                this.diary.setTrue(new SupportedFlags[]{SupportedFlags.PARNEW, SupportedFlags.SERIAL});
            } else {
                this.diary.setTrue(new SupportedFlags[]{SupportedFlags.PARALLELGC, SupportedFlags.PARALLELOLDGC});
            }
            this.diary.setFalse(new SupportedFlags[]{SupportedFlags.DEFNEW, SupportedFlags.PARNEW, SupportedFlags.SERIAL, SupportedFlags.CMS, SupportedFlags.ICMS, SupportedFlags.G1GC, SupportedFlags.GC_DETAILS, SupportedFlags.TENURING_DISTRIBUTION, SupportedFlags.GC_CAUSE, SupportedFlags.CMS_DEBUG_LEVEL_1, SupportedFlags.ADAPTIVE_SIZING, SupportedFlags.PRINT_HEAP_AT_GC, SupportedFlags.RSET_STATS, SupportedFlags.JDK70, SupportedFlags.PRE_JDK70_40, SupportedFlags.JDK80});
        } else if (this.simpleParallelOrParNewDetected) {
            if (this.ageTableDetected) {
                this.diary.setTrue(new SupportedFlags[]{SupportedFlags.PARNEW, SupportedFlags.CMS});
                this.diary.setFalse(new SupportedFlags[]{SupportedFlags.PARALLELGC, SupportedFlags.PARALLELOLDGC});
            } else {
                this.diary.setTrue(new SupportedFlags[]{SupportedFlags.PARALLELGC, SupportedFlags.PARALLELOLDGC});
                this.diary.setFalse(new SupportedFlags[]{SupportedFlags.PARNEW, SupportedFlags.CMS});
            }
            this.diary.setFalse(new SupportedFlags[]{SupportedFlags.DEFNEW, SupportedFlags.SERIAL, SupportedFlags.ICMS, SupportedFlags.G1GC, SupportedFlags.GC_DETAILS, SupportedFlags.TENURING_DISTRIBUTION, SupportedFlags.GC_CAUSE, SupportedFlags.CMS_DEBUG_LEVEL_1, SupportedFlags.ADAPTIVE_SIZING, SupportedFlags.PRINT_HEAP_AT_GC, SupportedFlags.RSET_STATS, SupportedFlags.JDK70, SupportedFlags.PRE_JDK70_40, SupportedFlags.JDK80});
        }
        this.diary.setFalse(new SupportedFlags[]{SupportedFlags.MAX_TENURING_THRESHOLD_VIOLATION, SupportedFlags.PRINT_PROMOTION_FAILURE, SupportedFlags.PRINT_FLS_STATISTICS});
    }

    public boolean diarize(String line) {
        this.timeOfFirstEvent(line);
        --this.lineCount;
        if (line.startsWith("Java HotSpot(TM)") || line.startsWith("OpenJDK")) {
            this.parseJVMVersion(line);
        } else if (line.startsWith("CommandLine ")) {
            this.evaluateCommandLineFlags(line.split(" "));
            this.lineCount = 25;
            this.collectionCount = 3;
        } else if (!this.jvmActivityFlag(line)) {
            this.collector(line);
            this.version(line);
            this.details(line);
        }
        return this.completed();
    }

    public DateTimeStamp getTimeOfFirstEvent() {
        if (this.timeOfFirstEvent == null) {
            this.timeOfFirstEvent = new DateTimeStamp(0.0);
        }
        return this.timeOfFirstEvent;
    }

    private void timeOfFirstEvent(String line) {
        if (this.timeOfFirstEvent == null) {
            Matcher matcher = excludeG1Ergonomics.matcher(line);
            if (matcher.find()) {
                return;
            }
            GCLogTrace trace = PreUnifiedTokens.DATE_TIMESTAMP_RECORD.parse(line);
            if (trace != null) {
                this.timeOfFirstEvent = trace.getDateTimeStamp();
                this.diary.setTimeOfFirstEvent(this.timeOfFirstEvent);
            }
        }
    }

    private boolean jvmActivityFlag(String line) {
        if (this.diary.isStateKnown(new SupportedFlags[]{SupportedFlags.APPLICATION_STOPPED_TIME, SupportedFlags.APPLICATION_CONCURRENT_TIME, SupportedFlags.TLAB_DATA})) {
            return false;
        }
        if (JVMPatterns.APPLICATION_STOP_TIME.parse(line) != null || JVMPatterns.SIMPLE_APPLICATION_STOP_TIME.parse(line) != null || JVMPatterns.APPLICATION_STOP_TIME_WITH_STOPPING_TIME.parse(line) != null) {
            this.diary.setTrue(SupportedFlags.APPLICATION_STOPPED_TIME);
            return true;
        }
        if (JVMPatterns.APPLICATION_TIME.parse(line) != null || JVMPatterns.SIMPLE_APPLICATION_TIME.parse(line) != null) {
            this.diary.setTrue(SupportedFlags.APPLICATION_CONCURRENT_TIME);
            return true;
        }
        if (JVMPatterns.TLAB_CONT.parse(line) != null) {
            this.diary.setTrue(SupportedFlags.TLAB_DATA);
            return true;
        }
        if (this.collectionCount > 1) {
            this.diary.setFalse(new SupportedFlags[]{SupportedFlags.APPLICATION_STOPPED_TIME, SupportedFlags.APPLICATION_CONCURRENT_TIME, SupportedFlags.TLAB_DATA});
        }
        return false;
    }

    private void collector(String line) {
        GCLogTrace trace;
        if (!this.diary.isStateKnown(new SupportedFlags[]{SupportedFlags.PARNEW, SupportedFlags.DEFNEW, SupportedFlags.PARALLELGC, SupportedFlags.G1GC}) || !this.diary.isStateKnown(SupportedFlags.GC_DETAILS) || this.collectionCount < 3) {
            if (line.contains("[PSYoungGen:")) {
                this.diary.setTrue(new SupportedFlags[]{SupportedFlags.PARALLELGC, SupportedFlags.PARALLELOLDGC});
                this.diary.setFalse(new SupportedFlags[]{SupportedFlags.DEFNEW, SupportedFlags.PARNEW, SupportedFlags.CMS, SupportedFlags.ICMS, SupportedFlags.SERIAL, SupportedFlags.G1GC, SupportedFlags.CMS_DEBUG_LEVEL_1, SupportedFlags.MAX_TENURING_THRESHOLD_VIOLATION, SupportedFlags.RSET_STATS});
                ++this.collectionCount;
                ++this.youngCollectionCount;
                trace = ParallelPatterns.PSYOUNGGEN.parse(line);
                if (trace != null) {
                    this.diary.setTrue(SupportedFlags.GC_DETAILS);
                    this.diary.setFalse(SupportedFlags.TENURING_DISTRIBUTION);
                    this.diary.setFalse(SupportedFlags.PRINT_HEAP_AT_GC);
                    this.setGCCause(trace.getGroup(6));
                } else if (ParallelPatterns.PS_DETAILS_WITH_TENURING.parse(line) != null) {
                    this.diary.setTrue(SupportedFlags.GC_DETAILS);
                    this.diary.setFalse(SupportedFlags.PRINT_HEAP_AT_GC);
                }
            } else if (line.contains("ParNew")) {
                this.diary.setTrue(new SupportedFlags[]{SupportedFlags.PARNEW, SupportedFlags.CMS});
                this.diary.setFalse(new SupportedFlags[]{SupportedFlags.DEFNEW, SupportedFlags.PARALLELGC, SupportedFlags.PARALLELOLDGC, SupportedFlags.SERIAL, SupportedFlags.G1GC, SupportedFlags.RSET_STATS});
                ++this.collectionCount;
                ++this.youngCollectionCount;
                trace = CMSPatterns.PARNEW.parse(line);
                if (trace != null) {
                    this.diary.setTrue(SupportedFlags.GC_DETAILS);
                    this.diary.setFalse(new SupportedFlags[]{SupportedFlags.TENURING_DISTRIBUTION, SupportedFlags.CMS_DEBUG_LEVEL_1, SupportedFlags.MAX_TENURING_THRESHOLD_VIOLATION});
                    this.setGCCause(trace.getGroup(7));
                } else {
                    trace = CMSPatterns.PARNEW_TENURING.parse(line);
                    if (trace != null) {
                        this.diary.setTrue(new SupportedFlags[]{SupportedFlags.GC_DETAILS, SupportedFlags.TENURING_DISTRIBUTION});
                        this.diary.setFalse(SupportedFlags.CMS_DEBUG_LEVEL_1);
                        this.setGCCause(trace.getGroup(6));
                    } else {
                        trace = SimplePatterns.PARNEW_NO_DETAILS.parse(line);
                        if (trace != null) {
                            this.diary.setFalse(new SupportedFlags[]{SupportedFlags.GC_DETAILS, SupportedFlags.TENURING_DISTRIBUTION, SupportedFlags.CMS_DEBUG_LEVEL_1, SupportedFlags.PRINT_HEAP_AT_GC, SupportedFlags.MAX_TENURING_THRESHOLD_VIOLATION});
                            this.setGCCause(trace.getGroup(6));
                        } else {
                            trace = SimplePatterns.PARNEW_START.parse(line);
                            if (trace != null) {
                                this.diary.setFalse(new SupportedFlags[]{SupportedFlags.GC_DETAILS, SupportedFlags.CMS_DEBUG_LEVEL_1, SupportedFlags.ADAPTIVE_SIZING, SupportedFlags.PRINT_HEAP_AT_GC});
                                this.setGCCause(trace.groupCount() > 5 ? trace.getGroup(6) : null);
                            } else {
                                trace = CMSPatterns.PARNEW_REFERENCE_SPLIT.parse(line);
                                if (trace != null) {
                                    this.diary.setTrue(new SupportedFlags[]{SupportedFlags.TENURING_DISTRIBUTION, SupportedFlags.PRINT_REFERENCE_GC});
                                    this.setGCCause(trace.getGroup(6));
                                }
                            }
                        }
                    }
                }
            } else {
                trace = SerialPatterns.DEFNEW.parse(line);
                if (trace != null) {
                    ++this.collectionCount;
                    ++this.youngCollectionCount;
                    this.diary.setTrue(new SupportedFlags[]{SupportedFlags.DEFNEW, SupportedFlags.GC_DETAILS});
                    this.diary.setFalse(new SupportedFlags[]{SupportedFlags.PARALLELGC, SupportedFlags.PARALLELOLDGC, SupportedFlags.PARNEW, SupportedFlags.G1GC, SupportedFlags.TENURING_DISTRIBUTION, SupportedFlags.RSET_STATS, SupportedFlags.MAX_TENURING_THRESHOLD_VIOLATION});
                    this.setGCCause(trace.getGroup(6));
                } else {
                    trace = SerialPatterns.DEFNEW_TENURING.parse(line);
                    if (trace != null) {
                        ++this.collectionCount;
                        ++this.youngCollectionCount;
                        this.diary.setTrue(new SupportedFlags[]{SupportedFlags.DEFNEW, SupportedFlags.GC_DETAILS, SupportedFlags.TENURING_DISTRIBUTION});
                        this.diary.setFalse(new SupportedFlags[]{SupportedFlags.PARNEW, SupportedFlags.PARALLELGC, SupportedFlags.PARALLELOLDGC, SupportedFlags.G1GC, SupportedFlags.RSET_STATS});
                        this.setGCCause(trace.getGroup(6));
                    } else if (SimplePatterns.PARNEW_NO_DETAILS.parse(line) != null) {
                        ++this.collectionCount;
                        ++this.youngCollectionCount;
                        this.diary.setTrue(SupportedFlags.PARNEW);
                        this.diary.setFalse(new SupportedFlags[]{SupportedFlags.DEFNEW, SupportedFlags.PARALLELGC, SupportedFlags.PARALLELOLDGC, SupportedFlags.G1GC, SupportedFlags.GC_DETAILS, SupportedFlags.TENURING_DISTRIBUTION, SupportedFlags.GC_CAUSE, SupportedFlags.CMS_DEBUG_LEVEL_1, SupportedFlags.ADAPTIVE_SIZING, SupportedFlags.PRINT_HEAP_AT_GC, SupportedFlags.RSET_STATS, SupportedFlags.MAX_TENURING_THRESHOLD_VIOLATION});
                    } else if (SimplePatterns.YOUNG_NO_DETAILS.parse(line) != null) {
                        ++this.collectionCount;
                        ++this.youngCollectionCount;
                        this.simpleParallelOrParNewDetected = true;
                        this.diary.setFalse(new SupportedFlags[]{SupportedFlags.G1GC, SupportedFlags.GC_DETAILS, SupportedFlags.TENURING_DISTRIBUTION, SupportedFlags.GC_CAUSE, SupportedFlags.JDK80, SupportedFlags.PRINT_HEAP_AT_GC, SupportedFlags.MAX_TENURING_THRESHOLD_VIOLATION, SupportedFlags.ADAPTIVE_SIZING});
                    } else if (SimplePatterns.FULL_NO_GC_DETAILS.parse(line) != null) {
                        ++this.collectionCount;
                        this.simpleFullGCDetected = true;
                        this.simpleParallelOrParNewDetected = true;
                    } else {
                        trace = SimplePatterns.GC_START.parse(line);
                        if (trace != null) {
                            ++this.collectionCount;
                            this.simpleParallelOrParNewDetected = true;
                            ++this.youngCollectionCount;
                            this.diary.setFalse(new SupportedFlags[]{SupportedFlags.G1GC, SupportedFlags.RSET_STATS});
                            this.setGCCause(trace.getGroup(6));
                        } else if (SimplePatterns.CMS_NO_DETAILS.parse(line) != null) {
                            ++this.collectionCount;
                            this.simpleParallelOrParNewDetected = true;
                            this.simpleCMSCycleDetected = true;
                            this.firstCMSCycle = true;
                        } else {
                            trace = G1GCPatterns.G1_YOUNG_SPLIT_START.parse(line);
                            if (trace != null) {
                                ++this.collectionCount;
                                ++this.youngCollectionCount;
                                this.diary.setFalse(new SupportedFlags[]{SupportedFlags.DEFNEW, SupportedFlags.PARNEW, SupportedFlags.CMS, SupportedFlags.ICMS, SupportedFlags.PARALLELGC, SupportedFlags.PARALLELOLDGC, SupportedFlags.SERIAL, SupportedFlags.CMS_DEBUG_LEVEL_1});
                                this.diary.setTrue(SupportedFlags.G1GC);
                                this.diary.setTrue(SupportedFlags.GC_DETAILS);
                                if (trace.gcCause() == GCCause.GCCAUSE_NOT_SET) {
                                    this.diary.setFalse(SupportedFlags.GC_CAUSE);
                                } else if (trace.gcCause() == GCCause.METADATA_GENERATION_THRESHOLD) {
                                    this.diary.setTrue(new SupportedFlags[]{SupportedFlags.GC_CAUSE, SupportedFlags.JDK80});
                                    this.diary.setFalse(new SupportedFlags[]{SupportedFlags.JDK70, SupportedFlags.PRE_JDK70_40});
                                } else if (trace.gcCause() == GCCause.G1_EVACUATION_PAUSE || trace.gcCause() == GCCause.G1_HUMONGOUS_ALLOCATION) {
                                    this.diary.setTrue(SupportedFlags.GC_CAUSE);
                                    this.diary.setFalse(SupportedFlags.PRE_JDK70_40);
                                }
                            } else {
                                trace = G1GCPatterns.G1_DETAILS.parse(line);
                                if (trace != null) {
                                    ++this.collectionCount;
                                    ++this.youngCollectionCount;
                                    this.diary.setTrue(new SupportedFlags[]{SupportedFlags.G1GC, SupportedFlags.GC_DETAILS});
                                    this.diary.setFalse(new SupportedFlags[]{SupportedFlags.DEFNEW, SupportedFlags.PARNEW, SupportedFlags.CMS, SupportedFlags.ICMS, SupportedFlags.PARALLELGC, SupportedFlags.PARALLELOLDGC, SupportedFlags.SERIAL, SupportedFlags.TENURING_DISTRIBUTION, SupportedFlags.CMS_DEBUG_LEVEL_1, SupportedFlags.MAX_TENURING_THRESHOLD_VIOLATION});
                                    if (trace.gcCause() == GCCause.GCCAUSE_NOT_SET) {
                                        this.diary.setFalse(new SupportedFlags[]{SupportedFlags.GC_CAUSE, SupportedFlags.JDK80});
                                        this.diary.setTrue(SupportedFlags.JDK70);
                                    } else {
                                        this.diary.setFalse(SupportedFlags.GC_CAUSE);
                                        this.diary.setFalse(SupportedFlags.PRE_JDK70_40);
                                    }
                                } else {
                                    trace = G1GCPatterns.YOUNG.parse(line);
                                    if (trace != null) {
                                        ++this.collectionCount;
                                        ++this.youngCollectionCount;
                                        this.diary.setFalse(new SupportedFlags[]{SupportedFlags.DEFNEW, SupportedFlags.PARNEW, SupportedFlags.CMS, SupportedFlags.ICMS, SupportedFlags.PARALLELGC, SupportedFlags.PARALLELOLDGC, SupportedFlags.SERIAL, SupportedFlags.GC_DETAILS, SupportedFlags.TENURING_DISTRIBUTION, SupportedFlags.CMS_DEBUG_LEVEL_1, SupportedFlags.MAX_TENURING_THRESHOLD_VIOLATION});
                                        this.diary.setTrue(SupportedFlags.G1GC);
                                        this.checkForGCCause(trace);
                                    } else {
                                        trace = G1GCPatterns.G1_DETAILS_REFERENCE_GC.parse(line);
                                        if (trace != null) {
                                            ++this.collectionCount;
                                            ++this.youngCollectionCount;
                                            this.diary.setFalse(new SupportedFlags[]{SupportedFlags.DEFNEW, SupportedFlags.PARNEW, SupportedFlags.CMS, SupportedFlags.ICMS, SupportedFlags.PARALLELGC, SupportedFlags.PARALLELOLDGC, SupportedFlags.SERIAL, SupportedFlags.TENURING_DISTRIBUTION, SupportedFlags.CMS_DEBUG_LEVEL_1, SupportedFlags.MAX_TENURING_THRESHOLD_VIOLATION});
                                            this.diary.setTrue(new SupportedFlags[]{SupportedFlags.G1GC, SupportedFlags.GC_DETAILS, SupportedFlags.PRINT_REFERENCE_GC});
                                            if (trace.getGroup(6) != null) {
                                                this.diary.setTrue(SupportedFlags.GC_CAUSE);
                                            } else {
                                                this.diary.setFalse(SupportedFlags.GC_CAUSE);
                                            }
                                        } else if (G1GCPatterns.G1_INITIAL_MARK.parse(line) != null) {
                                            ++this.collectionCount;
                                            ++this.youngCollectionCount;
                                            this.diary.setFalse(new SupportedFlags[]{SupportedFlags.DEFNEW, SupportedFlags.PARNEW, SupportedFlags.CMS, SupportedFlags.ICMS, SupportedFlags.PARALLELGC, SupportedFlags.PARALLELOLDGC, SupportedFlags.SERIAL, SupportedFlags.CMS_DEBUG_LEVEL_1, SupportedFlags.MAX_TENURING_THRESHOLD_VIOLATION});
                                            this.diary.setTrue(new SupportedFlags[]{SupportedFlags.G1GC, SupportedFlags.GC_DETAILS, SupportedFlags.GC_CAUSE, SupportedFlags.TENURING_DISTRIBUTION});
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        if (this.diary.isTrue(SupportedFlags.ADAPTIVE_SIZING) && (trace = G1GCPatterns.YOUNG_SPLIT_BY_G1ERGONOMICS.parse(line)) != null) {
            ++this.collectionCount;
            ++this.youngCollectionCount;
            this.diary.setTrue(new SupportedFlags[]{SupportedFlags.G1GC, SupportedFlags.GC_DETAILS});
            this.diary.setFalse(new SupportedFlags[]{SupportedFlags.DEFNEW, SupportedFlags.PARNEW, SupportedFlags.CMS, SupportedFlags.ICMS, SupportedFlags.PARALLELGC, SupportedFlags.PARALLELOLDGC, SupportedFlags.SERIAL, SupportedFlags.CMS_DEBUG_LEVEL_1});
            this.checkForGCCause(trace);
        }
        if (ParallelPatterns.PS_FULL_GC_PERM.parse(line) != null) {
            ++this.collectionCount;
            this.diary.setTrue(SupportedFlags.JDK70);
            this.diary.setFalse(SupportedFlags.JDK80);
            if (line.contains(" [PSYoungGen: ")) {
                this.diary.setTrue(SupportedFlags.PARALLELGC);
            }
            this.diary.setTrue(new SupportedFlags[]{SupportedFlags.PARALLELOLDGC, SupportedFlags.GC_DETAILS});
            this.diary.setFalse(new SupportedFlags[]{SupportedFlags.PARNEW, SupportedFlags.CMS, SupportedFlags.ICMS, SupportedFlags.SERIAL, SupportedFlags.G1GC});
            this.diary.setFalse(SupportedFlags.CMS_DEBUG_LEVEL_1);
            this.diary.setFalse(SupportedFlags.PRINT_HEAP_AT_GC);
        } else if (ParallelPatterns.PS_FULL_GC_META.parse(line) != null) {
            ++this.collectionCount;
            this.diary.setFalse(new SupportedFlags[]{SupportedFlags.JDK70, SupportedFlags.PRE_JDK70_40});
            this.diary.setTrue(SupportedFlags.JDK80);
            if (line.contains(" [PSYoungGen: ")) {
                this.diary.setTrue(SupportedFlags.PARALLELGC);
            }
            this.diary.setTrue(new SupportedFlags[]{SupportedFlags.PARALLELOLDGC, SupportedFlags.GC_DETAILS});
            this.diary.setFalse(new SupportedFlags[]{SupportedFlags.PARNEW, SupportedFlags.CMS, SupportedFlags.SERIAL, SupportedFlags.ICMS, SupportedFlags.G1GC});
            this.diary.setFalse(SupportedFlags.CMS_DEBUG_LEVEL_1);
            this.diary.setFalse(SupportedFlags.PRINT_HEAP_AT_GC);
        } else if (line.contains("CMS-initial-mark")) {
            ++this.collectionCount;
            this.diary.setFalse(new SupportedFlags[]{SupportedFlags.PARALLELGC, SupportedFlags.PARALLELOLDGC, SupportedFlags.SERIAL, SupportedFlags.G1GC});
            this.diary.setTrue(new SupportedFlags[]{SupportedFlags.CMS, SupportedFlags.GC_DETAILS});
        } else if (CMSPatterns.SERIAL_FULL.parse(line) != null) {
            ++this.collectionCount;
            this.diary.setFalse(new SupportedFlags[]{SupportedFlags.CMS, SupportedFlags.ICMS, SupportedFlags.PARALLELOLDGC, SupportedFlags.G1GC, SupportedFlags.CMS_DEBUG_LEVEL_1});
            this.diary.setTrue(new SupportedFlags[]{SupportedFlags.SERIAL, SupportedFlags.GC_DETAILS});
            this.diary.setFalse(SupportedFlags.CMS_DEBUG_LEVEL_1);
            if (line.contains("Metaspace")) {
                this.diary.setFalse(SupportedFlags.JDK70);
                this.diary.setTrue(new SupportedFlags[]{SupportedFlags.JDK80, SupportedFlags.GC_CAUSE});
            } else if (line.contains("Perm")) {
                this.diary.setFalse(SupportedFlags.JDK80);
            }
            if (line.contains("Tenured")) {
                this.diary.setFalse(new SupportedFlags[]{SupportedFlags.CMS, SupportedFlags.ICMS});
                this.diary.setTrue(SupportedFlags.SERIAL);
            } else if (line.contains("CMS")) {
                this.diary.setFalse(SupportedFlags.SERIAL);
                this.diary.setTrue(SupportedFlags.CMS);
            }
        } else if (CMSPatterns.SERIAL_FULL.parse(line) != null) {
            ++this.collectionCount;
            this.diary.setFalse(new SupportedFlags[]{SupportedFlags.CMS, SupportedFlags.ICMS, SupportedFlags.PARALLELOLDGC, SupportedFlags.G1GC, SupportedFlags.CMS_DEBUG_LEVEL_1, SupportedFlags.JDK70});
            this.diary.setTrue(new SupportedFlags[]{SupportedFlags.SERIAL, SupportedFlags.GC_DETAILS, SupportedFlags.GC_CAUSE, SupportedFlags.JDK80});
        } else if (TENURED_BLOCK.parse(line) != null) {
            ++this.collectionCount;
            this.diary.setFalse(SupportedFlags.CMS);
            this.diary.setFalse(SupportedFlags.ICMS);
            this.diary.setTrue(SupportedFlags.SERIAL);
            this.diary.setFalse(SupportedFlags.G1GC);
        }
        if (this.diary.isTrue(SupportedFlags.CMS) && !this.diary.isStateKnown(SupportedFlags.ICMS)) {
            if (this.firstCMSCycle) {
                if (line.contains("ParNew") || line.contains("DefNew")) {
                    ++this.youngCountAfterFirstCMSCycle;
                }
                if (line.contains("icms_dc")) {
                    this.diary.setTrue(SupportedFlags.ICMS);
                } else if (this.youngCountAfterFirstCMSCycle > 1) {
                    this.diary.setFalse(SupportedFlags.ICMS);
                }
            }
            if (line.contains("concurrent-reset")) {
                this.firstCMSCycle = true;
            }
        } else if (this.diary.isTrue(SupportedFlags.G1GC) && G1GCPatterns.G1_MEMORY_SUMMARY.parse(line) != null) {
            if (line.contains("Metaspace")) {
                this.diary.setFalse(new SupportedFlags[]{SupportedFlags.JDK70, SupportedFlags.PRE_JDK70_40});
                this.diary.setTrue(SupportedFlags.JDK80);
            } else {
                this.diary.setTrue(SupportedFlags.JDK70);
                this.diary.setFalse(SupportedFlags.JDK80);
            }
        }
    }

    private void checkForGCCause(GCLogTrace trace) {
        if (trace.gcCause() == GCCause.METADATA_GENERATION_THRESHOLD) {
            this.diary.setTrue(new SupportedFlags[]{SupportedFlags.GC_CAUSE, SupportedFlags.JDK80});
            this.diary.setFalse(new SupportedFlags[]{SupportedFlags.JDK70, SupportedFlags.PRE_JDK70_40});
        } else if (trace.gcCause() == GCCause.G1_EVACUATION_PAUSE || trace.gcCause() == GCCause.G1_HUMONGOUS_ALLOCATION) {
            this.diary.setTrue(SupportedFlags.GC_CAUSE);
        }
    }

    private void version(String line) {
        if (this.versionIsKnown()) {
            return;
        }
        GCLogTrace trace = ParallelPatterns.PERM_SPACE_RECORD.parse(line);
        if (trace != null) {
            String value;
            switch (value = trace.getGroup(1).trim()) {
                case "CMS Perm": 
                case "PS Perm": 
                case "Perm": 
                case "PSPermGen": {
                    this.diary.setTrue(SupportedFlags.JDK70);
                    this.diary.setFalse(SupportedFlags.JDK80);
                    break;
                }
                case "Metaspace": {
                    this.diary.setTrue(SupportedFlags.JDK80);
                    this.diary.setFalse(new SupportedFlags[]{SupportedFlags.JDK70, SupportedFlags.PRE_JDK70_40});
                }
            }
        } else if (SharedPatterns.META_SPACE_RECORD.parse(line) != null) {
            this.diary.setTrue(SupportedFlags.JDK80);
            this.diary.setFalse(new SupportedFlags[]{SupportedFlags.JDK70, SupportedFlags.PRE_JDK70_40});
        }
        if (line.contains("(System)")) {
            this.diary.setTrue(new SupportedFlags[]{SupportedFlags.JDK70, SupportedFlags.PRE_JDK70_40});
            this.diary.setFalse(new SupportedFlags[]{SupportedFlags.GC_CAUSE, SupportedFlags.JDK80});
        } else if (line.contains("(System.gc()")) {
            this.diary.setFalse(SupportedFlags.PRE_JDK70_40);
            this.diary.setTrue(SupportedFlags.GC_CAUSE);
        } else if (this.diary.isGenerationalKnown() && this.diary.isGenerational()) {
            trace = PREFIX.parse(line);
            if (trace != null) {
                if (trace.getGroup(6) == null && this.diary.isTrue(SupportedFlags.GC_DETAILS)) {
                    this.diary.setTrue(SupportedFlags.JDK70);
                    this.diary.setFalse(new SupportedFlags[]{SupportedFlags.JDK80, SupportedFlags.GC_CAUSE});
                } else if (trace.gcCause() != GCCause.GCCAUSE_NOT_SET) {
                    this.diary.setTrue(SupportedFlags.GC_CAUSE);
                    this.diary.setFalse(SupportedFlags.PRE_JDK70_40);
                }
            } else {
                trace = FULL_PREFIX.parse(line);
                if (trace != null) {
                    if (trace.getGroup(6) == null && this.diary.isTrue(SupportedFlags.GC_DETAILS)) {
                        this.diary.setTrue(SupportedFlags.JDK70);
                        this.diary.setFalse(new SupportedFlags[]{SupportedFlags.GC_CAUSE, SupportedFlags.JDK80});
                    } else if (trace.gcCause() != GCCause.GCCAUSE_NOT_SET) {
                        this.diary.setTrue(SupportedFlags.GC_CAUSE);
                        this.diary.setFalse(SupportedFlags.PRE_JDK70_40);
                    }
                }
            }
        } else if (this.diary.isG1GCKnown() && this.diary.isG1GC() && (trace = G1GC_PREFIX.parse(line)) != null) {
            if (this.diary.isTrue(SupportedFlags.GC_DETAILS) && trace.gcCause() == GCCause.GCCAUSE_NOT_SET) {
                this.diary.setTrue(SupportedFlags.JDK70);
                this.diary.setFalse(SupportedFlags.JDK80);
            } else {
                this.diary.setFalse(SupportedFlags.PRE_JDK70_40);
            }
        }
    }

    private void details(String line) {
        GCLogTrace gcLogTrace;
        GCLogTrace trace = PREFIX.parse(line);
        if (trace != null) {
            String cause = trace.getGroup(6);
            if (cause != null) {
                this.diary.setTrue(SupportedFlags.GC_CAUSE);
                if ("(System)".equals(cause)) {
                    this.diary.setFalse(SupportedFlags.JDK80);
                    this.diary.setTrue(SupportedFlags.JDK70);
                    this.diary.setTrue(SupportedFlags.PRE_JDK70_40);
                } else if ("(System.gc())".equals(cause)) {
                    this.diary.setFalse(SupportedFlags.PRE_JDK70_40);
                } else {
                    this.diary.setFalse(SupportedFlags.PRE_JDK70_40);
                }
            } else {
                trace = G1GC_PREFIX.parse(line);
                if (trace != null) {
                    cause = trace.getGroup(6);
                    if (cause == null) {
                        this.diary.setTrue(SupportedFlags.PRE_JDK70_40);
                    } else {
                        this.diary.setFalse(SupportedFlags.PRE_JDK70_40);
                    }
                } else {
                    this.diary.setFalse(SupportedFlags.GC_CAUSE);
                }
            }
            this.diary.setFalse(SupportedFlags.GC_CAUSE);
        } else if (line.contains("promotion failure size =")) {
            this.diary.setTrue(SupportedFlags.PRINT_PROMOTION_FAILURE);
        } else if (CMSPatterns.FLS_HEADER.parse(line) != null) {
            this.diary.setTrue(SupportedFlags.PRINT_FLS_STATISTICS);
        }
        if (this.diary.isG1GC()) {
            if (line.startsWith("[GC Worker Start (ms): ")) {
                if (line.startsWith("[GC Worker Start (ms): Min: ")) {
                    this.diary.setFalse(SupportedFlags.PRE_JDK70_40);
                } else {
                    this.diary.setTrue(SupportedFlags.PRE_JDK70_40);
                }
            }
        } else if (line.contains("AdaptiveSizePolicy::")) {
            this.diary.setTrue(SupportedFlags.ADAPTIVE_SIZING);
        }
        if (this.youngCollectionCount > 1 && !this.diary.isStateKnown(SupportedFlags.PRINT_REFERENCE_GC)) {
            this.diary.setFalse(SupportedFlags.PRINT_REFERENCE_GC);
        }
        if ((gcLogTrace = SharedPatterns.MEMORY_SUMMARY_RULE.parse(line)) != null && gcLogTrace.next() != null) {
            this.diary.setTrue(SupportedFlags.GC_DETAILS);
        }
        if (line.startsWith("{Heap before GC invocations=")) {
            this.diary.setTrue(SupportedFlags.PRINT_HEAP_AT_GC);
        } else if (this.collectionCount > 1) {
            this.diary.setFalse(SupportedFlags.PRINT_HEAP_AT_GC);
        }
        trace = TenuredPatterns.TENURING_SUMMARY.parse(line);
        if (trace != null) {
            if (this.tenuringSummary > 0 && !this.ageTableDetected) {
                this.diary.setTrue(new SupportedFlags[]{SupportedFlags.PARALLELGC, SupportedFlags.PARALLELOLDGC});
                this.diary.setFalse(new SupportedFlags[]{SupportedFlags.DEFNEW, SupportedFlags.PARNEW, SupportedFlags.CMS, SupportedFlags.ICMS, SupportedFlags.SERIAL, SupportedFlags.G1GC, SupportedFlags.CMS_DEBUG_LEVEL_1});
            } else {
                this.diary.setTrue(SupportedFlags.TENURING_DISTRIBUTION);
            }
            if (trace.getIntegerGroup(2) > 0) {
                ++this.tenuringSummary;
            }
            if (trace.getIntegerGroup(3) > 15) {
                this.maxTenuringThreshold = trace.getIntegerGroup(3);
                this.diary.setTrue(SupportedFlags.MAX_TENURING_THRESHOLD_VIOLATION);
            } else {
                this.diary.setFalse(SupportedFlags.MAX_TENURING_THRESHOLD_VIOLATION);
            }
        } else if (TenuredPatterns.TENURING_AGE_BREAKDOWN.parse(line) != null) {
            this.ageTableDetected = true;
            this.diary.setFalse(new SupportedFlags[]{SupportedFlags.PARALLELGC, SupportedFlags.PARALLELOLDGC});
        } else if (this.diary.isTenuringDistributionKnown() && this.collectionCount > 1 && this.youngCollectionCount > 1) {
            this.diary.setFalse(SupportedFlags.TENURING_DISTRIBUTION);
        }
        if (line.contains("G1Ergonomics") && (line.contains("CSet Construction") || line.contains("Heap Sizing"))) {
            ++this.collectionCount;
            this.diary.setTrue(new SupportedFlags[]{SupportedFlags.G1GC, SupportedFlags.ADAPTIVE_SIZING});
            this.diary.setFalse(new SupportedFlags[]{SupportedFlags.DEFNEW, SupportedFlags.PARNEW, SupportedFlags.CMS, SupportedFlags.ICMS, SupportedFlags.PARALLELGC, SupportedFlags.PARALLELOLDGC, SupportedFlags.SERIAL, SupportedFlags.CMS_DEBUG_LEVEL_1});
        }
        if (REFERENCE_PROCESSING_BLOCK.parse(line) != null) {
            this.diary.setTrue(SupportedFlags.PRINT_REFERENCE_GC);
        }
        if (line.startsWith("Concurrent RS processed")) {
            ++this.collectionCount;
            this.diary.setTrue(new SupportedFlags[]{SupportedFlags.G1GC, SupportedFlags.RSET_STATS});
            this.diary.setFalse(new SupportedFlags[]{SupportedFlags.DEFNEW, SupportedFlags.PARNEW, SupportedFlags.CMS, SupportedFlags.ICMS, SupportedFlags.PARALLELGC, SupportedFlags.PARALLELOLDGC, SupportedFlags.SERIAL, SupportedFlags.CMS_DEBUG_LEVEL_1});
        } else if (line.contains(" (cardTable: ")) {
            this.diary.setTrue(SupportedFlags.CMS_DEBUG_LEVEL_1);
        }
        if (this.collectionCount > 1) {
            if (!this.diary.isCMSDebugLevel1Known()) {
                this.diary.setFalse(SupportedFlags.CMS_DEBUG_LEVEL_1);
            }
            if (!this.diary.isAdaptiveSizingKnown()) {
                this.diary.setFalse(SupportedFlags.ADAPTIVE_SIZING);
            }
            if (!this.diary.isRSetStatsKnown()) {
                this.diary.setFalse(SupportedFlags.RSET_STATS);
            }
        }
    }

    private void evaluateCommandLineFlags(String[] commandLineFlags) {
        block22: for (String rawFlag : commandLineFlags) {
            String flag = this.processRawFlag(rawFlag);
            boolean flagTurnedOn = this.isSetToTrue(rawFlag);
            CommandLineFlag supportedFlag = CommandLineFlag.fromString(flag);
            if (supportedFlag != null) {
                switch (supportedFlag) {
                    case PrintGCApplicationStoppedTime: {
                        this.diary.setState(SupportedFlags.APPLICATION_STOPPED_TIME, flagTurnedOn);
                        break;
                    }
                    case PrintGCApplicationConcurrentTime: {
                        this.diary.setState(SupportedFlags.APPLICATION_CONCURRENT_TIME, flagTurnedOn);
                        break;
                    }
                    case PrintGCTimeStamps: {
                        break;
                    }
                    case PrintGCDetails: {
                        this.diary.setState(SupportedFlags.GC_DETAILS, flagTurnedOn);
                        if (!flagTurnedOn || !this.diary.isJDK80() && !this.diary.isUnifiedLogging()) continue block22;
                        this.diary.setTrue(SupportedFlags.GC_CAUSE);
                        break;
                    }
                    case PrintGCCause: {
                        this.diary.setState(SupportedFlags.GC_CAUSE, flagTurnedOn);
                        break;
                    }
                    case PrintTenuringDistribution: {
                        this.diary.setState(SupportedFlags.TENURING_DISTRIBUTION, flagTurnedOn);
                        break;
                    }
                    case PrintAdaptiveSizePolicy: {
                        this.diary.setState(SupportedFlags.ADAPTIVE_SIZING, flagTurnedOn);
                        break;
                    }
                    case PrintReferenceGC: {
                        this.diary.setState(SupportedFlags.PRINT_REFERENCE_GC, flagTurnedOn);
                        break;
                    }
                    case PrintHeapAtGC: {
                        this.diary.setState(SupportedFlags.PRINT_HEAP_AT_GC, flagTurnedOn);
                        break;
                    }
                    case PrintPromotionFailure: {
                        this.diary.setTrue(SupportedFlags.PRINT_PROMOTION_FAILURE);
                    }
                    case PrintFLSStatistics: {
                        this.diary.setTrue(SupportedFlags.PRINT_FLS_STATISTICS);
                    }
                }
                continue;
            }
            GarbageCollectorFlag gcFlag = GarbageCollectorFlag.fromString(flag);
            if (gcFlag == null) continue;
            switch (gcFlag) {
                case UseSerialGC: {
                    this.setGCFlags |= flagTurnedOn ? 1 : 256;
                    continue block22;
                }
                case UseParallelGC: {
                    this.setGCFlags |= flagTurnedOn ? 2 : 512;
                    continue block22;
                }
                case UseParallelOldGC: {
                    this.setGCFlags |= flagTurnedOn ? 4 : 1024;
                    continue block22;
                }
                case UseParNewGC: {
                    this.setGCFlags |= flagTurnedOn ? 8 : 2048;
                    continue block22;
                }
                case UseConcMarkSweepGC: {
                    this.setGCFlags |= flagTurnedOn ? 16 : 4096;
                    continue block22;
                }
                case CMSIncrementialMode: {
                    this.setGCFlags |= flagTurnedOn ? 32 : 0;
                    continue block22;
                }
                case UseG1GC: {
                    this.setGCFlags |= flagTurnedOn ? 64 : 16384;
                    continue block22;
                }
            }
        }
        this.evaluateGCLogFlags();
        this.diary.setFalse(new SupportedFlags[]{SupportedFlags.APPLICATION_STOPPED_TIME, SupportedFlags.APPLICATION_CONCURRENT_TIME, SupportedFlags.GC_DETAILS, SupportedFlags.GC_CAUSE, SupportedFlags.TENURING_DISTRIBUTION, SupportedFlags.ADAPTIVE_SIZING, SupportedFlags.PRINT_REFERENCE_GC, SupportedFlags.PRINT_HEAP_AT_GC, SupportedFlags.PRINT_PROMOTION_FAILURE, SupportedFlags.PRINT_FLS_STATISTICS});
    }

    private String processRawFlag(String rawFlag) {
        int equalsPosition;
        String processedFlag = "";
        if (rawFlag.startsWith("-XX:") && (equalsPosition = (processedFlag = rawFlag.charAt(4) == '+' || rawFlag.charAt(4) == '-' ? rawFlag.substring(5) : rawFlag.substring(4)).indexOf("=")) > 0) {
            processedFlag = processedFlag.substring(0, equalsPosition);
        }
        return processedFlag;
    }

    private boolean isSetToTrue(String flag) {
        return flag.startsWith("-XX:+");
    }

    private void parseJVMVersion(String versionString) {
        Matcher matcher = VERSION.matcher(versionString);
        if (matcher.find()) {
            switch (matcher.group(2).charAt(0)) {
                case '7': {
                    this.diary.setTrue(SupportedFlags.JDK70);
                    this.diary.setFalse(SupportedFlags.JDK80);
                    if (matcher.group(3) == null) {
                        this.diary.setTrue(SupportedFlags.PRE_JDK70_40);
                    }
                    try {
                        int minorVersion = Integer.parseInt(matcher.group(3).substring(1));
                        if (minorVersion < 41) {
                            this.diary.setTrue(SupportedFlags.PRE_JDK70_40);
                            break;
                        }
                        this.diary.setFalse(SupportedFlags.PRE_JDK70_40);
                    }
                    catch (NumberFormatException nfe) {
                        this.diary.setTrue(SupportedFlags.PRE_JDK70_40);
                    }
                    break;
                }
                case '8': {
                    this.diary.setFalse(new SupportedFlags[]{SupportedFlags.JDK70, SupportedFlags.PRE_JDK70_40});
                    this.diary.setTrue(new SupportedFlags[]{SupportedFlags.JDK80, SupportedFlags.GC_CAUSE});
                    break;
                }
                case '9': {
                    this.diary.setFalse(new SupportedFlags[]{SupportedFlags.JDK70, SupportedFlags.PRE_JDK70_40, SupportedFlags.JDK80});
                    break;
                }
            }
        }
    }

    private void evaluateGCLogFlags() {
        switch (this.setGCFlags) {
            case 0: 
            case 2: 
            case 4: 
            case 6: 
            case 256: 
            case 258: 
            case 260: 
            case 518: 
            case 2050: 
            case 4354: 
            case 6146: 
            case 16384: {
                this.diary.setTrue(new SupportedFlags[]{SupportedFlags.PARALLELGC, SupportedFlags.PARALLELOLDGC});
                this.diary.setFalse(new SupportedFlags[]{SupportedFlags.DEFNEW, SupportedFlags.PARNEW, SupportedFlags.CMS, SupportedFlags.ICMS, SupportedFlags.SERIAL, SupportedFlags.G1GC, SupportedFlags.RSET_STATS, SupportedFlags.CMS_DEBUG_LEVEL_1});
                break;
            }
            case 1024: 
            case 1026: {
                this.diary.setTrue(SupportedFlags.PARALLELGC);
                this.diary.setFalse(new SupportedFlags[]{SupportedFlags.DEFNEW, SupportedFlags.PARNEW, SupportedFlags.CMS, SupportedFlags.ICMS, SupportedFlags.PARALLELOLDGC, SupportedFlags.SERIAL, SupportedFlags.G1GC, SupportedFlags.RSET_STATS, SupportedFlags.CMS_DEBUG_LEVEL_1});
                break;
            }
            case 1: {
                this.diary.setTrue(new SupportedFlags[]{SupportedFlags.DEFNEW, SupportedFlags.SERIAL});
                this.diary.setFalse(new SupportedFlags[]{SupportedFlags.PARNEW, SupportedFlags.CMS, SupportedFlags.ICMS, SupportedFlags.PARALLELGC, SupportedFlags.PARALLELOLDGC, SupportedFlags.G1GC, SupportedFlags.RSET_STATS, SupportedFlags.CMS_DEBUG_LEVEL_1});
                break;
            }
            case 8: 
            case 4101: {
                this.diary.setTrue(new SupportedFlags[]{SupportedFlags.PARNEW, SupportedFlags.SERIAL});
                this.diary.setFalse(new SupportedFlags[]{SupportedFlags.DEFNEW, SupportedFlags.CMS, SupportedFlags.ICMS, SupportedFlags.PARALLELGC, SupportedFlags.PARALLELOLDGC, SupportedFlags.G1GC, SupportedFlags.RSET_STATS, SupportedFlags.CMS_DEBUG_LEVEL_1});
                break;
            }
            case 16: 
            case 24: 
            case 272: {
                this.diary.setTrue(new SupportedFlags[]{SupportedFlags.PARNEW, SupportedFlags.CMS});
                this.diary.setFalse(new SupportedFlags[]{SupportedFlags.DEFNEW, SupportedFlags.ICMS, SupportedFlags.PARALLELGC, SupportedFlags.PARALLELOLDGC, SupportedFlags.SERIAL, SupportedFlags.G1GC, SupportedFlags.RSET_STATS});
                break;
            }
            case 2064: {
                this.diary.setTrue(new SupportedFlags[]{SupportedFlags.DEFNEW, SupportedFlags.CMS});
                this.diary.setFalse(new SupportedFlags[]{SupportedFlags.PARNEW, SupportedFlags.ICMS, SupportedFlags.PARALLELGC, SupportedFlags.PARALLELOLDGC, SupportedFlags.SERIAL, SupportedFlags.G1GC, SupportedFlags.RSET_STATS});
                break;
            }
            case 48: 
            case 56: {
                this.diary.setTrue(new SupportedFlags[]{SupportedFlags.PARNEW, SupportedFlags.CMS, SupportedFlags.ICMS});
                this.diary.setFalse(new SupportedFlags[]{SupportedFlags.DEFNEW, SupportedFlags.PARALLELGC, SupportedFlags.PARALLELOLDGC, SupportedFlags.SERIAL, SupportedFlags.G1GC, SupportedFlags.RSET_STATS});
                break;
            }
            case 2096: {
                this.diary.setTrue(new SupportedFlags[]{SupportedFlags.DEFNEW, SupportedFlags.CMS, SupportedFlags.ICMS});
                this.diary.setFalse(new SupportedFlags[]{SupportedFlags.PARNEW, SupportedFlags.PARALLELGC, SupportedFlags.PARALLELOLDGC, SupportedFlags.SERIAL, SupportedFlags.G1GC, SupportedFlags.RSET_STATS});
                break;
            }
            case 64: 
            case 6208: {
                this.diary.setTrue(SupportedFlags.G1GC);
                this.diary.setFalse(new SupportedFlags[]{SupportedFlags.DEFNEW, SupportedFlags.PARNEW, SupportedFlags.CMS, SupportedFlags.ICMS, SupportedFlags.PARALLELGC, SupportedFlags.PARALLELOLDGC, SupportedFlags.SERIAL, SupportedFlags.CMS_DEBUG_LEVEL_1});
                break;
            }
            case 4096: {
                this.diary.setTrue(new SupportedFlags[]{SupportedFlags.PARALLELGC, SupportedFlags.PARALLELOLDGC});
                this.diary.setFalse(new SupportedFlags[]{SupportedFlags.DEFNEW, SupportedFlags.PARNEW, SupportedFlags.CMS, SupportedFlags.ICMS, SupportedFlags.G1GC, SupportedFlags.RSET_STATS, SupportedFlags.SERIAL, SupportedFlags.CMS_DEBUG_LEVEL_1});
                break;
            }
            case 4160: {
                this.diary.setTrue(SupportedFlags.G1GC);
                this.diary.setFalse(new SupportedFlags[]{SupportedFlags.PARALLELGC, SupportedFlags.PARALLELOLDGC, SupportedFlags.DEFNEW, SupportedFlags.PARNEW, SupportedFlags.CMS, SupportedFlags.ICMS, SupportedFlags.SERIAL, SupportedFlags.CMS_DEBUG_LEVEL_1});
                break;
            }
            default: {
                LOGGER.severe("Illegal internal state: GCToolKit was unable to properly identify this log. Results will be corrupted.");
            }
        }
    }

    private void setGCCause(String gcCause) {
        if (gcCause == null && this.diary.isPrintGCDetails()) {
            this.diary.setFalse(new SupportedFlags[]{SupportedFlags.GC_CAUSE, SupportedFlags.JDK80});
        } else if (gcCause != null) {
            if (GCCauses.get((String)gcCause) == GCCause.GCCAUSE_NOT_SET) {
                if (this.diary.isPrintGCDetailsKnown() && this.diary.isPrintGCDetails()) {
                    this.diary.setFalse(new SupportedFlags[]{SupportedFlags.GC_CAUSE, SupportedFlags.JDK80});
                    this.diary.setTrue(SupportedFlags.JDK70);
                }
            } else if (gcCause.contains("System.gc()") || !gcCause.contains("System")) {
                this.diary.setTrue(SupportedFlags.GC_CAUSE);
                this.diary.setFalse(SupportedFlags.PRE_JDK70_40);
            } else {
                this.diary.setTrue(SupportedFlags.PRE_JDK70_40);
                this.diary.setTrue(SupportedFlags.JDK70);
            }
        }
    }
}

