/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.gctoolkit.vertx;

import com.microsoft.gctoolkit.event.jvm.JVMEvent;
import com.microsoft.gctoolkit.message.ChannelName;
import com.microsoft.gctoolkit.message.JVMEventChannel;
import com.microsoft.gctoolkit.message.JVMEventChannelListener;
import com.microsoft.gctoolkit.vertx.JVMEventVerticle;
import com.microsoft.gctoolkit.vertx.VertxChannel;
import com.microsoft.gctoolkit.vertx.io.JVMEventCodec;
import io.vertx.core.Verticle;
import io.vertx.core.eventbus.DeliveryOptions;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;

public class VertxJVMEventChannel
extends VertxChannel
implements JVMEventChannel {
    private final DeliveryOptions options = new DeliveryOptions().setCodecName(JVMEventCodec.NAME);

    public void registerListener(JVMEventChannelListener listener) {
        JVMEventVerticle processor = new JVMEventVerticle(this.vertx(), listener.channel().getName(), listener);
        CountDownLatch latch = new CountDownLatch(1);
        this.vertx().deployVerticle((Verticle)processor, state -> {
            processor.setID(state.succeeded() ? (String)state.result() : "");
            latch.countDown();
        });
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            LOGGER.log(Level.SEVERE, "Vert.x: Latch.await interrupted: " + e.getLocalizedMessage(), e);
        }
    }

    public void publish(ChannelName channel, JVMEvent message) {
        try {
            this.vertx().eventBus().publish(channel.getName(), (Object)message, this.options);
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "Vert.x: Unable to publish message: " + String.valueOf(message), ex);
        }
    }

    @Override
    public void close() {
        super.close();
    }
}

