/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.content;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSink;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class MSBatchResponseContent {
    private Response batchResponse;
    private Map<String, Request> batchRequestsHashMap;
    private JSONArray batchResponseArray;
    private String nextLink;

    public MSBatchResponseContent(Response batchResponse) {
        this.batchResponse = batchResponse;
        this.update(batchResponse);
    }

    public Response getResponseById(String requestId) {
        if (this.batchResponseArray == null) {
            return null;
        }
        JSONArray responses = this.batchResponseArray;
        for (Object response : responses) {
            JSONObject jsonresponse = (JSONObject)response;
            String id = (String)jsonresponse.get((Object)"id");
            if (id.compareTo(requestId) != 0) continue;
            Response.Builder builder = new Response.Builder();
            builder.request(this.batchRequestsHashMap.get(requestId));
            builder.protocol(this.batchResponse.protocol());
            builder.message(this.batchResponse.message());
            if (jsonresponse.get((Object)"status") != null) {
                Long status = (Long)jsonresponse.get((Object)"status");
                builder.code(status.intValue());
            }
            if (jsonresponse.get((Object)"body") != null) {
                JSONObject jsonObject = (JSONObject)jsonresponse.get((Object)"body");
                String bodyAsString = jsonObject.toJSONString();
                ResponseBody responseBody = ResponseBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)bodyAsString);
                builder.body(responseBody);
            }
            if (jsonresponse.get((Object)"headers") != null) {
                JSONObject jsonheaders = (JSONObject)jsonresponse.get((Object)"headers");
                for (Object key : jsonheaders.keySet()) {
                    String strkey = (String)key;
                    String strvalue = (String)jsonheaders.get((Object)strkey);
                    for (String value : strvalue.split(";")) {
                        builder.header(strkey, value);
                    }
                }
            }
            return builder.build();
        }
        return null;
    }

    public Map<String, Response> getResponses() {
        if (this.batchResponseArray == null) {
            return null;
        }
        HashMap<String, Response> responsesMap = new HashMap<String, Response>();
        for (String id : this.batchRequestsHashMap.keySet()) {
            responsesMap.put(id, this.getResponseById(id));
        }
        return responsesMap;
    }

    public Iterator<Map.Entry<String, Response>> getResponsesIterator() {
        Map<String, Response> responsesMap = this.getResponses();
        return responsesMap != null ? responsesMap.entrySet().iterator() : null;
    }

    public void update(Response batchResponse) {
        if (batchResponse == null) {
            throw new IllegalArgumentException("Batch Response cannot be null");
        }
        Map<String, Request> requestMap = this.createBatchRequestsHashMap(batchResponse);
        if (this.batchRequestsHashMap == null) {
            this.batchRequestsHashMap = new HashMap<String, Request>();
        }
        if (requestMap != null) {
            this.batchRequestsHashMap.putAll(requestMap);
        }
        if (batchResponse.body() != null) {
            try {
                JSONObject batchResponseObj;
                String batchResponseData = batchResponse.body().string();
                if (batchResponseData != null && (batchResponseObj = this.stringToJSONObject(batchResponseData)) != null) {
                    JSONArray responseArray;
                    JSONObject nextLinkObject = (JSONObject)batchResponseObj.get((Object)"@odata.nextLink");
                    if (nextLinkObject != null) {
                        this.nextLink = nextLinkObject.toString();
                    }
                    if (this.batchResponseArray == null) {
                        this.batchResponseArray = new JSONArray();
                    }
                    if ((responseArray = (JSONArray)batchResponseObj.get((Object)"responses")) != null) {
                        this.batchResponseArray.addAll((Collection)responseArray);
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public String nextLink() {
        return this.nextLink;
    }

    private Map<String, Request> createBatchRequestsHashMap(Response batchResponse) {
        if (batchResponse == null) {
            return null;
        }
        try {
            HashMap<String, Request> batchRequestsHashMap = new HashMap<String, Request>();
            JSONObject requestJSONObject = this.requestBodyToJSONObject(batchResponse.request());
            JSONArray requestArray = (JSONArray)requestJSONObject.get((Object)"requests");
            for (Object item : requestArray) {
                JSONObject requestObject = (JSONObject)item;
                Request.Builder builder = new Request.Builder();
                if (requestObject.get((Object)"url") != null) {
                    StringBuilder fullUrl = new StringBuilder(batchResponse.request().url().toString().replace("$batch", ""));
                    fullUrl.append(requestObject.get((Object)"url").toString());
                    builder.url(fullUrl.toString());
                }
                if (requestObject.get((Object)"headers") != null) {
                    JSONObject jsonheaders = (JSONObject)requestObject.get((Object)"headers");
                    for (Object key : jsonheaders.keySet()) {
                        String strkey = (String)key;
                        String strvalue = (String)jsonheaders.get((Object)strkey);
                        for (String value : strvalue.split("; ")) {
                            builder.header(strkey, value);
                        }
                    }
                }
                if (requestObject.get((Object)"body") != null) {
                    JSONObject jsonObject = (JSONObject)requestObject.get((Object)"body");
                    String bodyAsString = jsonObject.toJSONString();
                    RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)bodyAsString);
                    builder.method(requestObject.get((Object)"method").toString(), requestBody);
                } else {
                    builder.method(requestObject.get((Object)"method").toString(), null);
                }
                batchRequestsHashMap.put(requestObject.get((Object)"id").toString(), builder.build());
            }
            return batchRequestsHashMap;
        }
        catch (IOException | ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    private JSONObject stringToJSONObject(String input) {
        JSONParser parser = new JSONParser();
        JSONObject jsonObject = null;
        try {
            if (input != null) {
                jsonObject = (JSONObject)parser.parse(input);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return jsonObject;
    }

    private JSONObject requestBodyToJSONObject(Request request) throws IOException, ParseException {
        if (request == null || request.body() == null) {
            return null;
        }
        Request copy = request.newBuilder().build();
        Buffer buffer = new Buffer();
        copy.body().writeTo((BufferedSink)buffer);
        String requestBody = buffer.readUtf8();
        JSONObject jsonObject = (JSONObject)new JSONParser().parse(requestBody);
        return jsonObject;
    }
}

