/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.core.content;

import com.microsoft.graph.core.content.BatchRequestContent;
import com.microsoft.graph.core.content.BatchResponseContent;
import com.microsoft.graph.core.models.BatchRequestStep;
import com.microsoft.graph.core.requests.IBaseClient;
import com.microsoft.kiota.RequestInformation;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import okhttp3.Request;

public class BatchRequestContentCollection {
    private IBaseClient baseClient;
    private List<BatchRequestContent> batchRequests;
    private int batchRequestLimit;
    private BatchRequestContent currentBatchRequest;
    private boolean readOnly = false;

    public BatchRequestContentCollection(@Nonnull IBaseClient baseClient) {
        this(baseClient, 20);
    }

    public BatchRequestContentCollection(@Nonnull IBaseClient baseClient, int batchRequestLimit) {
        Objects.requireNonNull(baseClient, "The following parameter cannot be null: baseClient");
        if (batchRequestLimit < 2 || batchRequestLimit > 20) {
            throw new IllegalArgumentException("batchRequestLimit must be between 2 and 20");
        }
        this.baseClient = baseClient;
        this.batchRequestLimit = batchRequestLimit;
        this.batchRequests = new ArrayList<BatchRequestContent>();
        this.currentBatchRequest = new BatchRequestContent(baseClient);
    }

    @Nonnull
    public String addBatchRequestStep(@Nonnull Request request) {
        this.setupCurrentRequest();
        return this.currentBatchRequest.addBatchRequestStep(request);
    }

    @Nonnull
    public String addBatchRequestStep(@Nonnull RequestInformation requestInformation) {
        this.setupCurrentRequest();
        return this.currentBatchRequest.addBatchRequestStep(requestInformation);
    }

    public boolean removeBatchRequestStepWithId(@Nonnull String requestId) {
        this.validateReadOnly();
        boolean removed = this.currentBatchRequest.removeBatchRequestStepWithId(requestId);
        if (!removed && !this.batchRequests.isEmpty()) {
            for (BatchRequestContent batchRequest : this.batchRequests) {
                removed = batchRequest.removeBatchRequestStepWithId(requestId);
                if (!removed) continue;
                return true;
            }
        }
        return removed;
    }

    @Nonnull
    public List<BatchRequestContent> getBatchRequestsForExecution() {
        this.readOnly = true;
        if (this.currentBatchRequest.getBatchRequestSteps().size() > 0) {
            this.batchRequests.add(this.currentBatchRequest);
        }
        return new ArrayList<BatchRequestContent>(this.batchRequests);
    }

    @Nonnull
    public Map<String, BatchRequestStep> getBatchRequestSteps() {
        if (!this.batchRequests.isEmpty()) {
            Map<String, BatchRequestStep> result = this.currentBatchRequest.getBatchRequestSteps();
            for (BatchRequestContent batchRequestContent : this.batchRequests) {
                result.putAll(batchRequestContent.getBatchRequestSteps());
            }
            return result;
        }
        return this.currentBatchRequest.getBatchRequestSteps();
    }

    @Nonnull
    public BatchRequestContentCollection newBatchWithFailedRequests(@Nonnull Map<String, Integer> responseStatusCodes) {
        BatchRequestContentCollection newBatch = new BatchRequestContentCollection(this.baseClient, this.batchRequestLimit);
        Map<String, BatchRequestStep> steps = this.getBatchRequestSteps();
        responseStatusCodes.forEach((id, statusCode) -> {
            if (steps.containsKey(id) && !BatchResponseContent.isSuccessStatusCode(statusCode)) {
                newBatch.addBatchRequestStep(((BatchRequestStep)steps.get(id)).getRequest());
            }
        });
        return newBatch;
    }

    private void validateReadOnly() {
        if (this.readOnly) {
            throw new UnsupportedOperationException("Batch request collection is already executed");
        }
    }

    private void setupCurrentRequest() {
        this.validateReadOnly();
        if (this.currentBatchRequest.getBatchRequestSteps().size() >= this.batchRequestLimit) {
            this.batchRequests.add(this.currentBatchRequest);
            this.currentBatchRequest = new BatchRequestContent(this.baseClient);
        }
    }
}

