/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.core.content;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.microsoft.graph.core.requests.ResponseBodyHandler;
import com.microsoft.kiota.ResponseHandler;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParsableFactory;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import okhttp3.MediaType;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class BatchResponseContent {
    private Response batchResponse;
    private JsonObject jsonBatchResponseObject;
    private HashMap<String, ParsableFactory<? extends Parsable>> apiErrorMappings;
    private Protocol batchResponseProtocol;
    private Request batchResponseRequest;

    public BatchResponseContent(@Nonnull Response batchResponse) {
        this(batchResponse, null);
    }

    public BatchResponseContent(@Nonnull Response batchResponse, @Nullable Map<String, ParsableFactory<? extends Parsable>> apiErrorMappings) {
        this.batchResponse = Objects.requireNonNull(batchResponse, "The following parameter cannot be null: batchResponse");
        this.batchResponseProtocol = batchResponse.protocol();
        this.batchResponseRequest = batchResponse.request();
        this.apiErrorMappings = apiErrorMappings == null ? new HashMap() : new HashMap<String, ParsableFactory<? extends Parsable>>(apiErrorMappings);
    }

    @Nonnull
    public Map<String, Response> getResponses() {
        JsonElement responsesElement;
        HashMap<String, Response> responses = new HashMap<String, Response>();
        JsonObject jsonObject = this.jsonBatchResponseObject = this.jsonBatchResponseObject != null ? this.jsonBatchResponseObject : this.getBatchResponseContent();
        if (this.jsonBatchResponseObject != null && (responsesElement = this.jsonBatchResponseObject.get("responses")) != null && responsesElement.isJsonArray()) {
            JsonArray responsesArray = responsesElement.getAsJsonArray();
            for (JsonElement responseElement : responsesArray) {
                responses.put(responseElement.getAsJsonObject().get("id").getAsString(), this.getResponseFromJsonObject(responseElement));
            }
        }
        return responses;
    }

    @Nonnull
    public Map<String, Integer> getResponsesStatusCode() {
        JsonElement responsesElement;
        HashMap<String, Integer> statusCodes = new HashMap<String, Integer>();
        JsonObject jsonObject = this.jsonBatchResponseObject = this.jsonBatchResponseObject != null ? this.jsonBatchResponseObject : this.getBatchResponseContent();
        if (this.jsonBatchResponseObject != null && (responsesElement = this.jsonBatchResponseObject.get("responses")) != null && responsesElement.isJsonArray()) {
            JsonArray responsesArray = responsesElement.getAsJsonArray();
            for (JsonElement responseElement : responsesArray) {
                statusCodes.put(responseElement.getAsJsonObject().get("id").getAsString(), this.getStatusCodeFromJsonObject(responseElement));
            }
        }
        return statusCodes;
    }

    @Nullable
    public Response getResponseById(@Nonnull String requestId) {
        Objects.requireNonNull(requestId);
        if (!requestId.isEmpty()) {
            JsonElement responsesElement;
            JsonObject jsonObject = this.jsonBatchResponseObject = this.jsonBatchResponseObject != null ? this.jsonBatchResponseObject : this.getBatchResponseContent();
            if (this.jsonBatchResponseObject != null && (responsesElement = this.jsonBatchResponseObject.get("responses")) != null && responsesElement.isJsonArray()) {
                JsonArray responsesArray = responsesElement.getAsJsonArray();
                for (JsonElement responseElement : responsesArray) {
                    if (!responseElement.getAsJsonObject().get("id").getAsString().equals(requestId)) continue;
                    return this.getResponseFromJsonObject(responseElement);
                }
            }
        }
        return null;
    }

    @Nullable
    public <T extends Parsable> T getResponseById(@Nonnull String requestId, @Nonnull ResponseHandler responseHandler) {
        Response response = this.getResponseById(requestId);
        if (response == null) {
            return null;
        }
        return (T)((Parsable)responseHandler.handleResponse((Object)response, this.apiErrorMappings));
    }

    @Nullable
    public <T extends Parsable> T getResponseById(@Nonnull String requestId, @Nonnull ParsableFactory<T> factory) {
        return this.getResponseById(requestId, new ResponseBodyHandler<T>(factory));
    }

    @Nullable
    public InputStream getResponseStreamById(@Nonnull String requestId) {
        Response response = this.getResponseById(requestId);
        if (response != null && response.body() != null) {
            InputStream in = response.body().byteStream();
            return in;
        }
        return null;
    }

    @Nullable
    public String getNextLink() {
        JsonElement nextLinkElement;
        JsonObject jsonObject = this.jsonBatchResponseObject = this.jsonBatchResponseObject != null ? this.jsonBatchResponseObject : this.getBatchResponseContent();
        if (this.jsonBatchResponseObject != null && (nextLinkElement = this.jsonBatchResponseObject.get("@nextLink")) != null && nextLinkElement.isJsonPrimitive()) {
            return nextLinkElement.getAsString();
        }
        return null;
    }

    private JsonObject getBatchResponseContent() {
        if (this.batchResponse.body() != null && this.batchResponse.body().contentType() != null) {
            JsonObject jsonObject;
            InputStream in = this.batchResponse.body().byteStream();
            InputStreamReader reader = new InputStreamReader(in, StandardCharsets.UTF_8);
            try {
                jsonObject = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return null;
                }
            }
            reader.close();
            return jsonObject;
        }
        return null;
    }

    private Response getResponseFromJsonObject(JsonElement responseElement) {
        Response.Builder response = new Response.Builder();
        JsonObject responseObject = responseElement.getAsJsonObject();
        String message = null;
        if (responseObject.has("status")) {
            response.code(responseObject.get("status").getAsInt());
        }
        String contentType = null;
        if (responseObject.has("headers")) {
            JsonObject headers = responseObject.get("headers").getAsJsonObject();
            for (Map.Entry header : headers.entrySet()) {
                String key = (String)header.getKey();
                String value = ((JsonElement)header.getValue()).getAsString();
                if (key.equalsIgnoreCase("Content-Type")) {
                    contentType = value;
                }
                response.addHeader(key, value);
            }
        }
        if (responseObject.has("body")) {
            JsonObject bodyObject;
            String body = responseObject.get("body").toString();
            if (responseObject.get("body").isJsonObject() && (bodyObject = responseObject.get("body").getAsJsonObject()).has("error")) {
                JsonObject errorObject = bodyObject.get("error").getAsJsonObject();
                message = errorObject.get("message").getAsString();
            }
            ResponseBody responseBody = ResponseBody.create((String)body, (MediaType)MediaType.parse((String)(contentType != null ? contentType : "application/json")));
            response.body(responseBody);
            responseBody.close();
        }
        response.protocol(this.batchResponseProtocol);
        response.message(message == null ? "See status code for details" : message);
        response.request(this.batchResponseRequest);
        return response.build();
    }

    private int getStatusCodeFromJsonObject(JsonElement responseElement) {
        JsonObject responseObject = responseElement.getAsJsonObject();
        if (responseObject.has("status")) {
            return responseObject.get("status").getAsInt();
        }
        throw new IllegalArgumentException("Response object does not contain status code");
    }

    public static boolean isSuccessStatusCode(int statusCode) {
        return statusCode >= 200 && statusCode < 300;
    }
}

