/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.core.requests;

import com.azure.core.credential.TokenCredential;
import com.microsoft.graph.core.CoreConstants;
import com.microsoft.graph.core.authentication.AzureIdentityAccessTokenProvider;
import com.microsoft.graph.core.requests.middleware.GraphTelemetryHandler;
import com.microsoft.graph.core.requests.options.GraphClientOption;
import com.microsoft.kiota.RequestOption;
import com.microsoft.kiota.authentication.AccessTokenProvider;
import com.microsoft.kiota.authentication.BaseBearerTokenAuthenticationProvider;
import com.microsoft.kiota.http.KiotaClientFactory;
import com.microsoft.kiota.http.middleware.AuthorizationHandler;
import com.microsoft.kiota.http.middleware.UrlReplaceHandler;
import com.microsoft.kiota.http.middleware.options.UrlReplaceHandlerOption;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;

public class GraphClientFactory {
    private GraphClientFactory() {
    }

    @Nonnull
    public static OkHttpClient.Builder create() {
        return GraphClientFactory.create(new GraphClientOption());
    }

    @Nonnull
    public static OkHttpClient.Builder create(Interceptor ... interceptors) {
        return GraphClientFactory.create(new GraphClientOption(), interceptors);
    }

    @Nonnull
    public static OkHttpClient.Builder create(@Nonnull List<Interceptor> interceptors) {
        return GraphClientFactory.create(new GraphClientOption(), interceptors.toArray(new Interceptor[0]));
    }

    @Nonnull
    public static OkHttpClient.Builder create(@Nonnull TokenCredential tokenCredential) {
        return GraphClientFactory.create(tokenCredential, new RequestOption[0]);
    }

    @Nonnull
    public static OkHttpClient.Builder create(@Nonnull TokenCredential tokenCredential, @Nonnull RequestOption[] requestOptions) {
        return GraphClientFactory.create(new BaseBearerTokenAuthenticationProvider((AccessTokenProvider)new AzureIdentityAccessTokenProvider(tokenCredential)), requestOptions);
    }

    @Nonnull
    public static OkHttpClient.Builder create(@Nonnull BaseBearerTokenAuthenticationProvider authenticationProvider) {
        return GraphClientFactory.create(authenticationProvider, new RequestOption[0]);
    }

    @Nonnull
    public static OkHttpClient.Builder create(@Nonnull BaseBearerTokenAuthenticationProvider authenticationProvider, @Nonnull RequestOption[] requestOptions) {
        GraphClientOption graphClientOption = new GraphClientOption();
        ArrayList<RequestOption> requestOptionsList = new ArrayList<RequestOption>(Arrays.asList(requestOptions));
        requestOptionsList.add(graphClientOption);
        Interceptor[] interceptors = GraphClientFactory.createDefaultGraphInterceptors(requestOptionsList.toArray(new RequestOption[0]));
        ArrayList<Interceptor> interceptorList = new ArrayList<Interceptor>(Arrays.asList(interceptors));
        interceptorList.add((Interceptor)new AuthorizationHandler(authenticationProvider));
        graphClientOption.featureTracker.setFeatureUsage(4);
        return GraphClientFactory.create(graphClientOption, interceptorList);
    }

    @Nonnull
    public static OkHttpClient.Builder create(@Nonnull GraphClientOption graphClientOption, Interceptor ... interceptors) {
        OkHttpClient.Builder builder = KiotaClientFactory.create((Interceptor[])interceptors);
        List customInterceptors = builder.interceptors();
        boolean telemetryHandlerExists = customInterceptors.stream().anyMatch(x -> x instanceof GraphTelemetryHandler);
        if (!telemetryHandlerExists) {
            customInterceptors.add(new GraphTelemetryHandler(graphClientOption));
        }
        return builder;
    }

    @Nonnull
    public static OkHttpClient.Builder create(@Nonnull GraphClientOption graphClientOption, @Nonnull List<Interceptor> interceptors) {
        return GraphClientFactory.create(graphClientOption, interceptors.toArray(new Interceptor[0]));
    }

    @Nonnull
    public static OkHttpClient.Builder create(@Nullable GraphClientOption graphClientOption) {
        GraphClientOption option = graphClientOption == null ? new GraphClientOption() : graphClientOption;
        return KiotaClientFactory.create((Interceptor[])GraphClientFactory.createDefaultGraphInterceptors(option));
    }

    @Nonnull
    public static OkHttpClient.Builder create(@Nonnull RequestOption[] requestOptions) {
        return KiotaClientFactory.create((Interceptor[])GraphClientFactory.createDefaultGraphInterceptors(requestOptions));
    }

    @Nonnull
    public static Interceptor[] createDefaultGraphInterceptors(@Nonnull GraphClientOption graphClientOption) {
        return GraphClientFactory.getDefaultGraphInterceptors(new RequestOption[]{graphClientOption}).toArray(new Interceptor[0]);
    }

    @Nonnull
    public static Interceptor[] createDefaultGraphInterceptors(@Nonnull RequestOption[] requestOptions) {
        Objects.requireNonNull(requestOptions, "parameter requestOptions cannot be null");
        return GraphClientFactory.getDefaultGraphInterceptors(requestOptions).toArray(new Interceptor[0]);
    }

    private static List<Interceptor> getDefaultGraphInterceptors(@Nonnull RequestOption[] requestOptions) {
        GraphClientOption graphClientOption = new GraphClientOption();
        UrlReplaceHandlerOption urlReplaceHandlerOption = new UrlReplaceHandlerOption(CoreConstants.ReplacementConstants.getDefaultReplacementPairs());
        for (RequestOption option : requestOptions) {
            if (option instanceof UrlReplaceHandlerOption) {
                urlReplaceHandlerOption = (UrlReplaceHandlerOption)option;
            }
            if (!(option instanceof GraphClientOption)) continue;
            graphClientOption = (GraphClientOption)option;
        }
        ArrayList<Interceptor> handlers = new ArrayList<Interceptor>();
        handlers.add((Interceptor)new UrlReplaceHandler(urlReplaceHandlerOption));
        handlers.add(new GraphTelemetryHandler(graphClientOption));
        handlers.addAll(Arrays.asList(KiotaClientFactory.createDefaultInterceptors((RequestOption[])requestOptions)));
        GraphClientFactory.addDefaultFeatureUsages(graphClientOption);
        return handlers;
    }

    private static void addDefaultFeatureUsages(GraphClientOption graphClientOption) {
        graphClientOption.featureTracker.setFeatureUsage(2);
        graphClientOption.featureTracker.setFeatureUsage(1);
        graphClientOption.featureTracker.setFeatureUsage(4096);
    }
}

