/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.core.requests.upload;

import com.microsoft.graph.core.models.UploadResult;
import com.microsoft.graph.core.models.UploadSession;
import com.microsoft.kiota.ApiException;
import com.microsoft.kiota.ApiExceptionBuilder;
import com.microsoft.kiota.http.HeadersCompatibility;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParsableFactory;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.ParseNodeFactory;
import com.microsoft.kiota.serialization.ParseNodeFactoryRegistry;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Objects;
import okhttp3.Headers;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class UploadResponseHandler {
    private final ParseNodeFactory parseNodeFactory;

    public UploadResponseHandler() {
        this(null);
    }

    public UploadResponseHandler(@Nullable ParseNodeFactory parseNodeFactory) {
        this.parseNodeFactory = parseNodeFactory == null ? ParseNodeFactoryRegistry.defaultInstance : parseNodeFactory;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Nonnull
    public <T extends Parsable> UploadResult<T> handleResponse(@Nonnull Response response, @Nonnull ParsableFactory<T> factory) {
        Objects.requireNonNull(response);
        Objects.requireNonNull(factory);
        try (ResponseBody body = response.body();){
            UploadResult uploadResult;
            block23: {
                UploadResult uploadResult2 = new UploadResult();
                String contentLengthHeader = response.headers().get("content-length");
                if (Objects.isNull(body) || Objects.isNull(body.contentType()) || !Objects.isNull(contentLengthHeader) && Integer.parseInt(contentLengthHeader) == 0) {
                    String location;
                    if (response.code() == 201 && !Objects.isNull(location = response.headers().get("location")) && !location.isEmpty()) {
                        uploadResult2.location = new URI(location);
                        UploadResult uploadResult3 = uploadResult2;
                        return uploadResult3;
                    }
                    throw new ApiException("No Response Received for upload.");
                }
                InputStream in = body.byteStream();
                try {
                    String contentType;
                    if (!response.isSuccessful()) {
                        throw new ApiExceptionBuilder().withMessage("generalException").withResponseStatusCode(response.code()).withResponseHeaders(HeadersCompatibility.getResponseHeaders((Headers)response.headers())).build();
                    }
                    boolean canBeParsed = !Objects.isNull(contentLengthHeader) && Integer.parseInt(contentLengthHeader) > 0 || !Objects.isNull(body.contentType());
                    String string = contentType = canBeParsed ? body.contentType().toString().split(";")[0] : null;
                    if (canBeParsed) {
                        ParseNode parseNode = this.parseNodeFactory.getParseNode(contentType, in);
                        if (response.code() == 201) {
                            uploadResult2.itemResponse = parseNode.getObjectValue(factory);
                        } else {
                            UploadSession uploadSession = (UploadSession)parseNode.getObjectValue(UploadSession::createFromDiscriminatorValue);
                            List<String> nextExpectedRanges = uploadSession.getNextExpectedRanges();
                            if (nextExpectedRanges != null && !nextExpectedRanges.isEmpty()) {
                                uploadResult2.uploadSession = uploadSession;
                            } else {
                                uploadResult2.itemResponse = parseNode.getObjectValue(factory);
                            }
                        }
                    }
                    uploadResult = uploadResult2;
                    if (in == null) break block23;
                }
                catch (Throwable throwable) {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                in.close();
            }
            return uploadResult;
        }
        catch (IOException | URISyntaxException ex) {
            throw new RuntimeException(ex);
        }
    }
}

