// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models.extensions;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.extensions.ManagedDevice;
import com.microsoft.graph.models.extensions.Entity;
import com.microsoft.graph.requests.extensions.ManagedDeviceCollectionPage;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Detected App.
 */
public class DetectedApp extends Entity implements IJsonBackedObject {


    /**
     * The Device Count.
     * The number of devices that have installed this application
     */
    @SerializedName(value = "deviceCount", alternate = {"DeviceCount"})
    @Expose
    public Integer deviceCount;

    /**
     * The Display Name.
     * Name of the discovered application. Read-only
     */
    @SerializedName(value = "displayName", alternate = {"DisplayName"})
    @Expose
    public String displayName;

    /**
     * The Size In Byte.
     * Discovered application size in bytes. Read-only
     */
    @SerializedName(value = "sizeInByte", alternate = {"SizeInByte"})
    @Expose
    public Long sizeInByte;

    /**
     * The Version.
     * Version of the discovered application. Read-only
     */
    @SerializedName(value = "version", alternate = {"Version"})
    @Expose
    public String version;

    /**
     * The Managed Devices.
     * The devices that have the discovered application installed
     */
    public ManagedDeviceCollectionPage managedDevices;


    /**
     * The raw representation of this class
     */
    private JsonObject rawObject;

    /**
     * The serializer
     */
    private ISerializer serializer;

    /**
     * Gets the raw representation of this class
     *
     * @return the raw representation of this class
     */
    public JsonObject getRawObject() {
        return rawObject;
    }

    /**
     * Gets serializer
     *
     * @return the serializer
     */
    protected ISerializer getSerializer() {
        return serializer;
    }

    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(final ISerializer serializer, final JsonObject json) {
        this.serializer = serializer;
        rawObject = json;


        if (json.has("managedDevices")) {
            managedDevices = serializer.deserializeObject(json.get("managedDevices").toString(), ManagedDeviceCollectionPage.class);
        }
    }
}
