// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models.extensions;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.extensions.Entity;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Group Lifecycle Policy.
 */
public class GroupLifecyclePolicy extends Entity implements IJsonBackedObject {


    /**
     * The Alternate Notification Emails.
     * List of email address to send notifications for groups without owners. Multiple email address can be defined by separating email address with a semicolon.
     */
    @SerializedName(value = "alternateNotificationEmails", alternate = {"AlternateNotificationEmails"})
    @Expose
    public String alternateNotificationEmails;

    /**
     * The Group Lifetime In Days.
     * Number of days before a group expires and needs to be renewed. Once renewed, the group expiration is extended by the number of days defined.
     */
    @SerializedName(value = "groupLifetimeInDays", alternate = {"GroupLifetimeInDays"})
    @Expose
    public Integer groupLifetimeInDays;

    /**
     * The Managed Group Types.
     * The group type for which the expiration policy applies. Possible values are All, Selected or None.
     */
    @SerializedName(value = "managedGroupTypes", alternate = {"ManagedGroupTypes"})
    @Expose
    public String managedGroupTypes;


    /**
     * The raw representation of this class
     */
    private JsonObject rawObject;

    /**
     * The serializer
     */
    private ISerializer serializer;

    /**
     * Gets the raw representation of this class
     *
     * @return the raw representation of this class
     */
    public JsonObject getRawObject() {
        return rawObject;
    }

    /**
     * Gets serializer
     *
     * @return the serializer
     */
    protected ISerializer getSerializer() {
        return serializer;
    }

    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(final ISerializer serializer, final JsonObject json) {
        this.serializer = serializer;
        rawObject = json;

    }
}
