// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models.extensions;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.extensions.MimeContent;
import com.microsoft.graph.models.extensions.ManagedEBookAssignment;
import com.microsoft.graph.models.extensions.DeviceInstallState;
import com.microsoft.graph.models.extensions.EBookInstallSummary;
import com.microsoft.graph.models.extensions.UserInstallStateSummary;
import com.microsoft.graph.models.extensions.Entity;
import com.microsoft.graph.requests.extensions.ManagedEBookAssignmentCollectionPage;
import com.microsoft.graph.requests.extensions.DeviceInstallStateCollectionPage;
import com.microsoft.graph.requests.extensions.UserInstallStateSummaryCollectionPage;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Managed EBook.
 */
public class ManagedEBook extends Entity implements IJsonBackedObject {


    /**
     * The Created Date Time.
     * The date and time when the eBook file was created.
     */
    @SerializedName(value = "createdDateTime", alternate = {"CreatedDateTime"})
    @Expose
    public java.util.Calendar createdDateTime;

    /**
     * The Description.
     * Description.
     */
    @SerializedName(value = "description", alternate = {"Description"})
    @Expose
    public String description;

    /**
     * The Display Name.
     * Name of the eBook.
     */
    @SerializedName(value = "displayName", alternate = {"DisplayName"})
    @Expose
    public String displayName;

    /**
     * The Information Url.
     * The more information Url.
     */
    @SerializedName(value = "informationUrl", alternate = {"InformationUrl"})
    @Expose
    public String informationUrl;

    /**
     * The Large Cover.
     * Book cover.
     */
    @SerializedName(value = "largeCover", alternate = {"LargeCover"})
    @Expose
    public MimeContent largeCover;

    /**
     * The Last Modified Date Time.
     * The date and time when the eBook was last modified.
     */
    @SerializedName(value = "lastModifiedDateTime", alternate = {"LastModifiedDateTime"})
    @Expose
    public java.util.Calendar lastModifiedDateTime;

    /**
     * The Privacy Information Url.
     * The privacy statement Url.
     */
    @SerializedName(value = "privacyInformationUrl", alternate = {"PrivacyInformationUrl"})
    @Expose
    public String privacyInformationUrl;

    /**
     * The Published Date Time.
     * The date and time when the eBook was published.
     */
    @SerializedName(value = "publishedDateTime", alternate = {"PublishedDateTime"})
    @Expose
    public java.util.Calendar publishedDateTime;

    /**
     * The Publisher.
     * Publisher.
     */
    @SerializedName(value = "publisher", alternate = {"Publisher"})
    @Expose
    public String publisher;

    /**
     * The Assignments.
     * The list of assignments for this eBook.
     */
    @SerializedName(value = "assignments", alternate = {"Assignments"})
    @Expose
    public ManagedEBookAssignmentCollectionPage assignments;

    /**
     * The Device States.
     * The list of installation states for this eBook.
     */
    @SerializedName(value = "deviceStates", alternate = {"DeviceStates"})
    @Expose
    public DeviceInstallStateCollectionPage deviceStates;

    /**
     * The Install Summary.
     * Mobile App Install Summary.
     */
    @SerializedName(value = "installSummary", alternate = {"InstallSummary"})
    @Expose
    public EBookInstallSummary installSummary;

    /**
     * The User State Summary.
     * The list of installation states for this eBook.
     */
    @SerializedName(value = "userStateSummary", alternate = {"UserStateSummary"})
    @Expose
    public UserInstallStateSummaryCollectionPage userStateSummary;


    /**
     * The raw representation of this class
     */
    private JsonObject rawObject;

    /**
     * The serializer
     */
    private ISerializer serializer;

    /**
     * Gets the raw representation of this class
     *
     * @return the raw representation of this class
     */
    public JsonObject getRawObject() {
        return rawObject;
    }

    /**
     * Gets serializer
     *
     * @return the serializer
     */
    protected ISerializer getSerializer() {
        return serializer;
    }

    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(final ISerializer serializer, final JsonObject json) {
        this.serializer = serializer;
        rawObject = json;


        if (json.has("assignments")) {
            assignments = serializer.deserializeObject(json.get("assignments").toString(), ManagedEBookAssignmentCollectionPage.class);
        }

        if (json.has("deviceStates")) {
            deviceStates = serializer.deserializeObject(json.get("deviceStates").toString(), DeviceInstallStateCollectionPage.class);
        }

        if (json.has("userStateSummary")) {
            userStateSummary = serializer.deserializeObject(json.get("userStateSummary").toString(), UserInstallStateSummaryCollectionPage.class);
        }
    }
}
