// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models.extensions;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.generated.BookingType;
import com.microsoft.graph.models.extensions.Place;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Room.
 */
public class Room extends Place implements IJsonBackedObject {


    /**
     * The Audio Device Name.
     * Specifies the name of the audio device in the room.
     */
    @SerializedName(value = "audioDeviceName", alternate = {"AudioDeviceName"})
    @Expose
    public String audioDeviceName;

    /**
     * The Booking Type.
     * Type of room. Possible values are standard, and reserved.
     */
    @SerializedName(value = "bookingType", alternate = {"BookingType"})
    @Expose
    public BookingType bookingType;

    /**
     * The Building.
     * Specifies the building name or building number that the room is in.
     */
    @SerializedName(value = "building", alternate = {"Building"})
    @Expose
    public String building;

    /**
     * The Capacity.
     * Specifies the capacity of the room.
     */
    @SerializedName(value = "capacity", alternate = {"Capacity"})
    @Expose
    public Integer capacity;

    /**
     * The Display Device Name.
     * Specifies the name of the display device in the room.
     */
    @SerializedName(value = "displayDeviceName", alternate = {"DisplayDeviceName"})
    @Expose
    public String displayDeviceName;

    /**
     * The Email Address.
     * Email address of the room.
     */
    @SerializedName(value = "emailAddress", alternate = {"EmailAddress"})
    @Expose
    public String emailAddress;

    /**
     * The Floor Label.
     * Specifies a descriptive label for the floor, for example, P.
     */
    @SerializedName(value = "floorLabel", alternate = {"FloorLabel"})
    @Expose
    public String floorLabel;

    /**
     * The Floor Number.
     * Specifies the floor number that the room is on.
     */
    @SerializedName(value = "floorNumber", alternate = {"FloorNumber"})
    @Expose
    public Integer floorNumber;

    /**
     * The Is Wheel Chair Accessible.
     * 
     */
    @SerializedName(value = "isWheelChairAccessible", alternate = {"IsWheelChairAccessible"})
    @Expose
    public Boolean isWheelChairAccessible;

    /**
     * The Label.
     * Specifies a descriptive label for the room, for example, a number or name.
     */
    @SerializedName(value = "label", alternate = {"Label"})
    @Expose
    public String label;

    /**
     * The Nickname.
     * Specifies a nickname for the room, for example, 'conf room'.
     */
    @SerializedName(value = "nickname", alternate = {"Nickname"})
    @Expose
    public String nickname;

    /**
     * The Tags.
     * Specifies additional features of the room, for example, details like the type of view or furniture type.
     */
    @SerializedName(value = "tags", alternate = {"Tags"})
    @Expose
    public java.util.List<String> tags;

    /**
     * The Video Device Name.
     * Specifies the name of the video device in the room.
     */
    @SerializedName(value = "videoDeviceName", alternate = {"VideoDeviceName"})
    @Expose
    public String videoDeviceName;


    /**
     * The raw representation of this class
     */
    private JsonObject rawObject;

    /**
     * The serializer
     */
    private ISerializer serializer;

    /**
     * Gets the raw representation of this class
     *
     * @return the raw representation of this class
     */
    public JsonObject getRawObject() {
        return rawObject;
    }

    /**
     * Gets serializer
     *
     * @return the serializer
     */
    protected ISerializer getSerializer() {
        return serializer;
    }

    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(final ISerializer serializer, final JsonObject json) {
        this.serializer = serializer;
        rawObject = json;

    }
}
