// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models.extensions;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.generated.WellknownListName;
import com.microsoft.graph.models.extensions.Extension;
import com.microsoft.graph.models.extensions.TodoTask;
import com.microsoft.graph.models.extensions.Entity;
import com.microsoft.graph.requests.extensions.ExtensionCollectionPage;
import com.microsoft.graph.requests.extensions.TodoTaskCollectionPage;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Todo Task List.
 */
public class TodoTaskList extends Entity implements IJsonBackedObject {


    /**
     * The Display Name.
     * The name of the task list.
     */
    @SerializedName(value = "displayName", alternate = {"DisplayName"})
    @Expose
    public String displayName;

    /**
     * The Is Owner.
     * True if the user is owner of the given task list.
     */
    @SerializedName(value = "isOwner", alternate = {"IsOwner"})
    @Expose
    public Boolean isOwner;

    /**
     * The Is Shared.
     * True if the task list is shared with other users
     */
    @SerializedName(value = "isShared", alternate = {"IsShared"})
    @Expose
    public Boolean isShared;

    /**
     * The Wellknown List Name.
     * Property indicating the list name if the given list is a well-known list. Possible values are: none, defaultList, flaggedEmails, unknownFutureValue.
     */
    @SerializedName(value = "wellknownListName", alternate = {"WellknownListName"})
    @Expose
    public WellknownListName wellknownListName;

    /**
     * The Extensions.
     * The collection of open extensions defined for the task list. Nullable.
     */
    @SerializedName(value = "extensions", alternate = {"Extensions"})
    @Expose
    public ExtensionCollectionPage extensions;

    /**
     * The Tasks.
     * The tasks in this task list. Read-only. Nullable.
     */
    @SerializedName(value = "tasks", alternate = {"Tasks"})
    @Expose
    public TodoTaskCollectionPage tasks;


    /**
     * The raw representation of this class
     */
    private JsonObject rawObject;

    /**
     * The serializer
     */
    private ISerializer serializer;

    /**
     * Gets the raw representation of this class
     *
     * @return the raw representation of this class
     */
    public JsonObject getRawObject() {
        return rawObject;
    }

    /**
     * Gets serializer
     *
     * @return the serializer
     */
    protected ISerializer getSerializer() {
        return serializer;
    }

    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(final ISerializer serializer, final JsonObject json) {
        this.serializer = serializer;
        rawObject = json;


        if (json.has("extensions")) {
            extensions = serializer.deserializeObject(json.get("extensions").toString(), ExtensionCollectionPage.class);
        }

        if (json.has("tasks")) {
            tasks = serializer.deserializeObject(json.get("tasks").toString(), TodoTaskCollectionPage.class);
        }
    }
}
