// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models.extensions;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.extensions.WorkbookChartDataLabelFormat;
import com.microsoft.graph.models.extensions.Entity;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workbook Chart Data Labels.
 */
public class WorkbookChartDataLabels extends Entity implements IJsonBackedObject {


    /**
     * The Position.
     * DataLabelPosition value that represents the position of the data label. The possible values are: None, Center, InsideEnd, InsideBase, OutsideEnd, Left, Right, Top, Bottom, BestFit, Callout.
     */
    @SerializedName(value = "position", alternate = {"Position"})
    @Expose
    public String position;

    /**
     * The Separator.
     * String representing the separator used for the data labels on a chart.
     */
    @SerializedName(value = "separator", alternate = {"Separator"})
    @Expose
    public String separator;

    /**
     * The Show Bubble Size.
     * Boolean value representing if the data label bubble size is visible or not.
     */
    @SerializedName(value = "showBubbleSize", alternate = {"ShowBubbleSize"})
    @Expose
    public Boolean showBubbleSize;

    /**
     * The Show Category Name.
     * Boolean value representing if the data label category name is visible or not.
     */
    @SerializedName(value = "showCategoryName", alternate = {"ShowCategoryName"})
    @Expose
    public Boolean showCategoryName;

    /**
     * The Show Legend Key.
     * Boolean value representing if the data label legend key is visible or not.
     */
    @SerializedName(value = "showLegendKey", alternate = {"ShowLegendKey"})
    @Expose
    public Boolean showLegendKey;

    /**
     * The Show Percentage.
     * Boolean value representing if the data label percentage is visible or not.
     */
    @SerializedName(value = "showPercentage", alternate = {"ShowPercentage"})
    @Expose
    public Boolean showPercentage;

    /**
     * The Show Series Name.
     * Boolean value representing if the data label series name is visible or not.
     */
    @SerializedName(value = "showSeriesName", alternate = {"ShowSeriesName"})
    @Expose
    public Boolean showSeriesName;

    /**
     * The Show Value.
     * Boolean value representing if the data label value is visible or not.
     */
    @SerializedName(value = "showValue", alternate = {"ShowValue"})
    @Expose
    public Boolean showValue;

    /**
     * The Format.
     * Represents the format of chart data labels, which includes fill and font formatting. Read-only.
     */
    @SerializedName(value = "format", alternate = {"Format"})
    @Expose
    public WorkbookChartDataLabelFormat format;


    /**
     * The raw representation of this class
     */
    private JsonObject rawObject;

    /**
     * The serializer
     */
    private ISerializer serializer;

    /**
     * Gets the raw representation of this class
     *
     * @return the raw representation of this class
     */
    public JsonObject getRawObject() {
        return rawObject;
    }

    /**
     * Gets serializer
     *
     * @return the serializer
     */
    protected ISerializer getSerializer() {
        return serializer;
    }

    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(final ISerializer serializer, final JsonObject json) {
        this.serializer = serializer;
        rawObject = json;

    }
}
