// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.CertificateBasedAuthConfiguration;
import java.util.Arrays;
import java.util.EnumSet;

import com.microsoft.graph.models.extensions.CertificateBasedAuthConfiguration;
import com.microsoft.graph.http.IHttpRequest;
import com.microsoft.graph.serializer.IJsonBackedObject;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Certificate Based Auth Configuration Reference Request.
 */
public interface ICertificateBasedAuthConfigurationReferenceRequest extends IHttpRequest {

    void delete(final ICallback<? super CertificateBasedAuthConfiguration> callback);

    CertificateBasedAuthConfiguration delete() throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    ICertificateBasedAuthConfigurationReferenceRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    ICertificateBasedAuthConfigurationReferenceRequest expand(final String value);

    /**
     * Puts the CertificateBasedAuthConfiguration
     *
     * @param srcCertificateBasedAuthConfiguration the CertificateBasedAuthConfiguration to PUT
     * @param callback the callback to be called after success or failure
     */
    void put(CertificateBasedAuthConfiguration srcCertificateBasedAuthConfiguration, final ICallback<? super CertificateBasedAuthConfiguration> callback);

    /**
     * Puts the CertificateBasedAuthConfiguration
     *
     * @param srcCertificateBasedAuthConfiguration the CertificateBasedAuthConfiguration to PUT
     * @return the CertificateBasedAuthConfiguration
     * @throws ClientException an exception occurs if there was an error while the request was sent
     */
    CertificateBasedAuthConfiguration put(CertificateBasedAuthConfiguration srcCertificateBasedAuthConfiguration) throws ClientException;
}
