// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.ColumnLink;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Column Link Request.
 */
public interface IColumnLinkRequest extends IHttpRequest {

    /**
     * Gets the ColumnLink from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<? super ColumnLink> callback);

    /**
     * Gets the ColumnLink from the service
     *
     * @return the ColumnLink from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    ColumnLink get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<? super ColumnLink> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this ColumnLink with a source
     *
     * @param sourceColumnLink the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final ColumnLink sourceColumnLink, final ICallback<? super ColumnLink> callback);

    /**
     * Patches this ColumnLink with a source
     *
     * @param sourceColumnLink the source object with updates
     * @return the updated ColumnLink
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    ColumnLink patch(final ColumnLink sourceColumnLink) throws ClientException;

    /**
     * Posts a ColumnLink with a new object
     *
     * @param newColumnLink the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final ColumnLink newColumnLink, final ICallback<? super ColumnLink> callback);

    /**
     * Posts a ColumnLink with a new object
     *
     * @param newColumnLink the new object to create
     * @return the created ColumnLink
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    ColumnLink post(final ColumnLink newColumnLink) throws ClientException;

    /**
     * Posts a ColumnLink with a new object
     *
     * @param newColumnLink the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final ColumnLink newColumnLink, final ICallback<? super ColumnLink> callback);

    /**
     * Posts a ColumnLink with a new object
     *
     * @param newColumnLink the object to create/update
     * @return the created ColumnLink
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    ColumnLink put(final ColumnLink newColumnLink) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IColumnLinkRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IColumnLinkRequest expand(final String value);

}

