// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.Endpoint;
import java.util.Arrays;
import java.util.EnumSet;

import com.microsoft.graph.models.extensions.Endpoint;
import com.microsoft.graph.http.IHttpRequest;
import com.microsoft.graph.serializer.IJsonBackedObject;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Endpoint Reference Request.
 */
public interface IEndpointReferenceRequest extends IHttpRequest {

    void delete(final ICallback<? super Endpoint> callback);

    Endpoint delete() throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IEndpointReferenceRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IEndpointReferenceRequest expand(final String value);

    /**
     * Puts the Endpoint
     *
     * @param srcEndpoint the Endpoint to PUT
     * @param callback the callback to be called after success or failure
     */
    void put(Endpoint srcEndpoint, final ICallback<? super Endpoint> callback);

    /**
     * Puts the Endpoint
     *
     * @param srcEndpoint the Endpoint to PUT
     * @return the Endpoint
     * @throws ClientException an exception occurs if there was an error while the request was sent
     */
    Endpoint put(Endpoint srcEndpoint) throws ClientException;
}
