// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.ManagedDeviceMobileAppConfigurationDeviceSummary;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Managed Device Mobile App Configuration Device Summary Request.
 */
public interface IManagedDeviceMobileAppConfigurationDeviceSummaryRequest extends IHttpRequest {

    /**
     * Gets the ManagedDeviceMobileAppConfigurationDeviceSummary from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<? super ManagedDeviceMobileAppConfigurationDeviceSummary> callback);

    /**
     * Gets the ManagedDeviceMobileAppConfigurationDeviceSummary from the service
     *
     * @return the ManagedDeviceMobileAppConfigurationDeviceSummary from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    ManagedDeviceMobileAppConfigurationDeviceSummary get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<? super ManagedDeviceMobileAppConfigurationDeviceSummary> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this ManagedDeviceMobileAppConfigurationDeviceSummary with a source
     *
     * @param sourceManagedDeviceMobileAppConfigurationDeviceSummary the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final ManagedDeviceMobileAppConfigurationDeviceSummary sourceManagedDeviceMobileAppConfigurationDeviceSummary, final ICallback<? super ManagedDeviceMobileAppConfigurationDeviceSummary> callback);

    /**
     * Patches this ManagedDeviceMobileAppConfigurationDeviceSummary with a source
     *
     * @param sourceManagedDeviceMobileAppConfigurationDeviceSummary the source object with updates
     * @return the updated ManagedDeviceMobileAppConfigurationDeviceSummary
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    ManagedDeviceMobileAppConfigurationDeviceSummary patch(final ManagedDeviceMobileAppConfigurationDeviceSummary sourceManagedDeviceMobileAppConfigurationDeviceSummary) throws ClientException;

    /**
     * Posts a ManagedDeviceMobileAppConfigurationDeviceSummary with a new object
     *
     * @param newManagedDeviceMobileAppConfigurationDeviceSummary the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final ManagedDeviceMobileAppConfigurationDeviceSummary newManagedDeviceMobileAppConfigurationDeviceSummary, final ICallback<? super ManagedDeviceMobileAppConfigurationDeviceSummary> callback);

    /**
     * Posts a ManagedDeviceMobileAppConfigurationDeviceSummary with a new object
     *
     * @param newManagedDeviceMobileAppConfigurationDeviceSummary the new object to create
     * @return the created ManagedDeviceMobileAppConfigurationDeviceSummary
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    ManagedDeviceMobileAppConfigurationDeviceSummary post(final ManagedDeviceMobileAppConfigurationDeviceSummary newManagedDeviceMobileAppConfigurationDeviceSummary) throws ClientException;

    /**
     * Posts a ManagedDeviceMobileAppConfigurationDeviceSummary with a new object
     *
     * @param newManagedDeviceMobileAppConfigurationDeviceSummary the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final ManagedDeviceMobileAppConfigurationDeviceSummary newManagedDeviceMobileAppConfigurationDeviceSummary, final ICallback<? super ManagedDeviceMobileAppConfigurationDeviceSummary> callback);

    /**
     * Posts a ManagedDeviceMobileAppConfigurationDeviceSummary with a new object
     *
     * @param newManagedDeviceMobileAppConfigurationDeviceSummary the object to create/update
     * @return the created ManagedDeviceMobileAppConfigurationDeviceSummary
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    ManagedDeviceMobileAppConfigurationDeviceSummary put(final ManagedDeviceMobileAppConfigurationDeviceSummary newManagedDeviceMobileAppConfigurationDeviceSummary) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IManagedDeviceMobileAppConfigurationDeviceSummaryRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IManagedDeviceMobileAppConfigurationDeviceSummaryRequest expand(final String value);

}

