// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.OrgContact;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Org Contact Request.
 */
public interface IOrgContactRequest extends IHttpRequest {

    /**
     * Gets the OrgContact from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<? super OrgContact> callback);

    /**
     * Gets the OrgContact from the service
     *
     * @return the OrgContact from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    OrgContact get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<? super OrgContact> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this OrgContact with a source
     *
     * @param sourceOrgContact the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final OrgContact sourceOrgContact, final ICallback<? super OrgContact> callback);

    /**
     * Patches this OrgContact with a source
     *
     * @param sourceOrgContact the source object with updates
     * @return the updated OrgContact
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    OrgContact patch(final OrgContact sourceOrgContact) throws ClientException;

    /**
     * Posts a OrgContact with a new object
     *
     * @param newOrgContact the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final OrgContact newOrgContact, final ICallback<? super OrgContact> callback);

    /**
     * Posts a OrgContact with a new object
     *
     * @param newOrgContact the new object to create
     * @return the created OrgContact
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    OrgContact post(final OrgContact newOrgContact) throws ClientException;

    /**
     * Posts a OrgContact with a new object
     *
     * @param newOrgContact the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final OrgContact newOrgContact, final ICallback<? super OrgContact> callback);

    /**
     * Posts a OrgContact with a new object
     *
     * @param newOrgContact the object to create/update
     * @return the created OrgContact
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    OrgContact put(final OrgContact newOrgContact) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IOrgContactRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IOrgContactRequest expand(final String value);

}

