// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.Site;
import com.microsoft.graph.requests.extensions.ISiteGetByPathRequest;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Site Get By Path Request.
 */
public interface ISiteGetByPathRequest extends IHttpRequest {

    /**
     * Patches the SiteGetByPath
     *
     * @param srcSite the Site with which to PATCH
     * @param callback the callback to be called after success or failure
     */
    void patch(Site srcSite, final ICallback<? super Site> callback);

    /**
     * Patches the SiteGetByPath
     *
     * @param srcSite the Site with which to PATCH
     * @return the Site
     * @throws ClientException an exception occurs if there was an error while the request was sent
     */
    Site patch(Site srcSite) throws ClientException;

    /**
     * Puts the SiteGetByPath
     *
     * @param srcSite the Site to PUT
     * @param callback the callback to be called after success or failure
     */
    void put(Site srcSite, final ICallback<? super Site> callback);

    /**
     * Puts the SiteGetByPath
     *
     * @param srcSite the Site to PUT
     * @return the Site
     * @throws ClientException an exception occurs if there was an error while the request was sent
     */
     Site put(Site srcSite) throws ClientException;
    /**
     * Gets the Site
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<? super Site> callback);

    /**
     * Gets the Site
     *
     * @return the Site
     * @throws ClientException an exception occurs if there was an error while the request was sent
     */
    Site get() throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    ISiteGetByPathRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    ISiteGetByPathRequest expand(final String value);

}
