// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.Todo;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Todo Request.
 */
public interface ITodoRequest extends IHttpRequest {

    /**
     * Gets the Todo from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<? super Todo> callback);

    /**
     * Gets the Todo from the service
     *
     * @return the Todo from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    Todo get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<? super Todo> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this Todo with a source
     *
     * @param sourceTodo the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final Todo sourceTodo, final ICallback<? super Todo> callback);

    /**
     * Patches this Todo with a source
     *
     * @param sourceTodo the source object with updates
     * @return the updated Todo
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    Todo patch(final Todo sourceTodo) throws ClientException;

    /**
     * Posts a Todo with a new object
     *
     * @param newTodo the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final Todo newTodo, final ICallback<? super Todo> callback);

    /**
     * Posts a Todo with a new object
     *
     * @param newTodo the new object to create
     * @return the created Todo
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    Todo post(final Todo newTodo) throws ClientException;

    /**
     * Posts a Todo with a new object
     *
     * @param newTodo the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final Todo newTodo, final ICallback<? super Todo> callback);

    /**
     * Posts a Todo with a new object
     *
     * @param newTodo the object to create/update
     * @return the created Todo
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    Todo put(final Todo newTodo) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    ITodoRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    ITodoRequest expand(final String value);

}

