// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.TokenIssuancePolicy;
import java.util.Arrays;
import java.util.EnumSet;

import com.microsoft.graph.models.extensions.TokenIssuancePolicy;
import com.microsoft.graph.http.IHttpRequest;
import com.microsoft.graph.serializer.IJsonBackedObject;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Token Issuance Policy Reference Request.
 */
public interface ITokenIssuancePolicyReferenceRequest extends IHttpRequest {

    void delete(final ICallback<? super TokenIssuancePolicy> callback);

    TokenIssuancePolicy delete() throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    ITokenIssuancePolicyReferenceRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    ITokenIssuancePolicyReferenceRequest expand(final String value);

    /**
     * Puts the TokenIssuancePolicy
     *
     * @param srcTokenIssuancePolicy the TokenIssuancePolicy to PUT
     * @param callback the callback to be called after success or failure
     */
    void put(TokenIssuancePolicy srcTokenIssuancePolicy, final ICallback<? super TokenIssuancePolicy> callback);

    /**
     * Puts the TokenIssuancePolicy
     *
     * @param srcTokenIssuancePolicy the TokenIssuancePolicy to PUT
     * @return the TokenIssuancePolicy
     * @throws ClientException an exception occurs if there was an error while the request was sent
     */
    TokenIssuancePolicy put(TokenIssuancePolicy srcTokenIssuancePolicy) throws ClientException;
}
