// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.WorkbookChartAxes;
import com.microsoft.graph.requests.extensions.IWorkbookChartAxisRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Workbook Chart Axes Request Builder.
 */
public interface IWorkbookChartAxesRequestBuilder extends IRequestBuilder {
    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the IWorkbookChartAxesRequest instance
     */
    IWorkbookChartAxesRequest buildRequest(final com.microsoft.graph.options.Option... requestOptions);

    /**
     * Creates the request with specific options instead of the existing options
     *
     * @param requestOptions the options for this request
     * @return the IWorkbookChartAxesRequest instance
     */
    IWorkbookChartAxesRequest buildRequest(final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions);


    /**
     * Gets the request builder for WorkbookChartAxis
     *
     * @return the IWorkbookChartAxisRequestBuilder instance
     */
    IWorkbookChartAxisRequestBuilder categoryAxis();

    /**
     * Gets the request builder for WorkbookChartAxis
     *
     * @return the IWorkbookChartAxisRequestBuilder instance
     */
    IWorkbookChartAxisRequestBuilder seriesAxis();

    /**
     * Gets the request builder for WorkbookChartAxis
     *
     * @return the IWorkbookChartAxisRequestBuilder instance
     */
    IWorkbookChartAxisRequestBuilder valueAxis();

}