// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.ItemActivityStat;
import java.util.Arrays;
import java.util.EnumSet;

import com.microsoft.graph.requests.extensions.IListItemGetActivitiesByIntervalCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.ListItemGetActivitiesByIntervalCollectionPage;
import com.microsoft.graph.requests.extensions.ListItemGetActivitiesByIntervalCollectionResponse;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import com.microsoft.graph.http.IBaseCollectionPage;
import com.microsoft.graph.http.BaseCollectionPage;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the List Item Get Activities By Interval Collection Page.
 */
public class ListItemGetActivitiesByIntervalCollectionPage extends BaseCollectionPage<ItemActivityStat, IListItemGetActivitiesByIntervalCollectionRequestBuilder> implements IListItemGetActivitiesByIntervalCollectionPage {

    /**
     * A collection page for ItemActivityStat.
     *
     * @param response The serialized ListItemGetActivitiesByIntervalCollectionResponse from the service
     * @param builder The request builder for the next collection page
     */
    public ListItemGetActivitiesByIntervalCollectionPage(final ListItemGetActivitiesByIntervalCollectionResponse response, final IListItemGetActivitiesByIntervalCollectionRequestBuilder builder) {
       super(response.value, builder, response.additionalDataManager());
    }
}
