// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.requests.extensions.IManagedDeviceLogoutSharedAppleDeviceActiveUserRequest;
import com.microsoft.graph.requests.extensions.ManagedDeviceLogoutSharedAppleDeviceActiveUserRequest;

import com.microsoft.graph.core.BaseActionRequestBuilder;
import com.microsoft.graph.core.BaseFunctionRequestBuilder;
import com.microsoft.graph.core.IBaseClient;
import com.google.gson.JsonElement;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Managed Device Logout Shared Apple Device Active User Request Builder.
 */
public class ManagedDeviceLogoutSharedAppleDeviceActiveUserRequestBuilder extends BaseActionRequestBuilder implements IManagedDeviceLogoutSharedAppleDeviceActiveUserRequestBuilder {

    /**
     * The request builder for this ManagedDeviceLogoutSharedAppleDeviceActiveUser
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ManagedDeviceLogoutSharedAppleDeviceActiveUserRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the IManagedDeviceLogoutSharedAppleDeviceActiveUserRequest
     *
     * @param requestOptions the options for the request
     * @return the IManagedDeviceLogoutSharedAppleDeviceActiveUserRequest instance
     */
    public IManagedDeviceLogoutSharedAppleDeviceActiveUserRequest buildRequest(final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the IManagedDeviceLogoutSharedAppleDeviceActiveUserRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return the IManagedDeviceLogoutSharedAppleDeviceActiveUserRequest instance
     */
    public IManagedDeviceLogoutSharedAppleDeviceActiveUserRequest buildRequest(final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        ManagedDeviceLogoutSharedAppleDeviceActiveUserRequest request = new ManagedDeviceLogoutSharedAppleDeviceActiveUserRequest(
                getRequestUrl(),
                getClient(),
                requestOptions
        );

        return request;
    }
}
