// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.Shift;
import java.util.Arrays;
import java.util.EnumSet;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Shift Request.
 */
public class ShiftRequest extends BaseRequest implements IShiftRequest {
	
    /**
     * The request for the Shift
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ShiftRequest(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, Shift.class);
    }

    /**
     * Gets the Shift from the service
     *
     * @param callback the callback to be called after success or failure
     */
    public void get(final ICallback<? super Shift> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the Shift from the service
     *
     * @return the Shift from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public Shift get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    public void delete(final ICallback<? super Shift> callback) {
        send(HttpMethod.DELETE, callback, null);
    }

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {
        send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this Shift with a source
     *
     * @param sourceShift the source object with updates
     * @param callback the callback to be called after success or failure
     */
    public void patch(final Shift sourceShift, final ICallback<? super Shift> callback) {
        send(HttpMethod.PATCH, callback, sourceShift);
    }

    /**
     * Patches this Shift with a source
     *
     * @param sourceShift the source object with updates
     * @return the updated Shift
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public Shift patch(final Shift sourceShift) throws ClientException {
        return send(HttpMethod.PATCH, sourceShift);
    }

    /**
     * Creates a Shift with a new object
     *
     * @param newShift the new object to create
     * @param callback the callback to be called after success or failure
     */
    public void post(final Shift newShift, final ICallback<? super Shift> callback) {
        send(HttpMethod.POST, callback, newShift);
    }

    /**
     * Creates a Shift with a new object
     *
     * @param newShift the new object to create
     * @return the created Shift
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public Shift post(final Shift newShift) throws ClientException {
        return send(HttpMethod.POST, newShift);
    }

    /**
     * Creates a Shift with a new object
     *
     * @param newShift the object to create/update
     * @param callback the callback to be called after success or failure
     */
    public void put(final Shift newShift, final ICallback<? super Shift> callback) {
        send(HttpMethod.PUT, callback, newShift);
    }

    /**
     * Creates a Shift with a new object
     *
     * @param newShift the object to create/update
     * @return the created Shift
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public Shift put(final Shift newShift) throws ClientException {
        return send(HttpMethod.PUT, newShift);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     public IShiftRequest select(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$select", value));
         return (ShiftRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     public IShiftRequest expand(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$expand", value));
         return (ShiftRequest)this;
     }

}

