/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.core;

import com.microsoft.graph.authentication.IAuthenticationProvider;
import com.microsoft.graph.concurrency.DefaultExecutors;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.IClientConfig;
import com.microsoft.graph.http.CoreHttpProvider;
import com.microsoft.graph.http.IHttpProvider;
import com.microsoft.graph.logger.DefaultLogger;
import com.microsoft.graph.logger.ILogger;
import com.microsoft.graph.serializer.DefaultSerializer;
import com.microsoft.graph.serializer.ISerializer;
import okhttp3.OkHttpClient;

public abstract class DefaultClientConfig
implements IClientConfig {
    private IExecutors executors;
    private IHttpProvider httpProvider;
    private ILogger logger;
    private ISerializer serializer;

    public static IClientConfig createWithAuthenticationProvider(final IAuthenticationProvider authenticationProvider) {
        DefaultClientConfig config = new DefaultClientConfig(){

            @Override
            public IAuthenticationProvider getAuthenticationProvider() {
                return authenticationProvider;
            }
        };
        config.getLogger().logDebug("Using provided auth provider " + authenticationProvider.getClass().getSimpleName());
        return config;
    }

    @Override
    public abstract IAuthenticationProvider getAuthenticationProvider();

    @Override
    public IHttpProvider getHttpProvider() {
        return this.getHttpProvider(null);
    }

    @Override
    public <T1> IHttpProvider getHttpProvider(T1 httpClient) {
        if (this.httpProvider == null) {
            this.httpProvider = httpClient instanceof OkHttpClient ? new CoreHttpProvider(this, (OkHttpClient)httpClient) : new CoreHttpProvider(this, null);
            this.getLogger().logDebug("Created CoreHttpProvider");
        }
        return this.httpProvider;
    }

    @Override
    public ISerializer getSerializer() {
        if (this.serializer == null) {
            this.serializer = new DefaultSerializer(this.getLogger());
            this.getLogger().logDebug("Created DefaultSerializer");
        }
        return this.serializer;
    }

    @Override
    public IExecutors getExecutors() {
        if (this.executors == null) {
            this.executors = new DefaultExecutors(this.getLogger());
            this.getLogger().logDebug("Created DefaultExecutors");
        }
        return this.executors;
    }

    @Override
    public ILogger getLogger() {
        if (this.logger == null) {
            this.logger = new DefaultLogger();
            this.logger.logDebug("Created DefaultLogger");
        }
        return this.logger;
    }
}

