/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.core.BaseActionRequestBuilder;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.models.extensions.ItemReference;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.extensions.DriveItemRestoreRequest;
import com.microsoft.graph.requests.extensions.IDriveItemRestoreRequest;
import com.microsoft.graph.requests.extensions.IDriveItemRestoreRequestBuilder;
import java.util.List;

public class DriveItemRestoreRequestBuilder
extends BaseActionRequestBuilder
implements IDriveItemRestoreRequestBuilder {
    public DriveItemRestoreRequestBuilder(String requestUrl, IBaseClient client, List<? extends Option> requestOptions, ItemReference parentReference, String name) {
        super(requestUrl, client, requestOptions);
        this.bodyParams.put("parentReference", parentReference);
        this.bodyParams.put("name", name);
    }

    @Override
    public IDriveItemRestoreRequest buildRequest(Option ... requestOptions) {
        return this.buildRequest(this.getOptions(requestOptions));
    }

    @Override
    public IDriveItemRestoreRequest buildRequest(List<? extends Option> requestOptions) {
        DriveItemRestoreRequest request = new DriveItemRestoreRequest(this.getRequestUrl(), this.getClient(), requestOptions);
        if (this.hasParameter("parentReference")) {
            request.body.parentReference = (ItemReference)this.getParameter("parentReference");
        }
        if (this.hasParameter("name")) {
            request.body.name = (String)this.getParameter("name");
        }
        return request;
    }
}

