/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.EducationSchool;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.EducationSchoolCollectionPage;
import com.microsoft.graph.requests.extensions.EducationSchoolCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.EducationSchoolCollectionResponse;
import com.microsoft.graph.requests.extensions.EducationSchoolRequestBuilder;
import com.microsoft.graph.requests.extensions.IEducationSchoolCollectionPage;
import com.microsoft.graph.requests.extensions.IEducationSchoolCollectionRequest;
import java.util.List;

public class EducationSchoolCollectionRequest
extends BaseCollectionRequest<EducationSchoolCollectionResponse, IEducationSchoolCollectionPage>
implements IEducationSchoolCollectionRequest {
    public EducationSchoolCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, EducationSchoolCollectionResponse.class, IEducationSchoolCollectionPage.class);
    }

    @Override
    public void get(final ICallback<? super IEducationSchoolCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(EducationSchoolCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IEducationSchoolCollectionPage get() throws ClientException {
        EducationSchoolCollectionResponse response = (EducationSchoolCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(EducationSchool newEducationSchool, ICallback<? super EducationSchool> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new EducationSchoolRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newEducationSchool, callback);
    }

    @Override
    public EducationSchool post(EducationSchool newEducationSchool) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new EducationSchoolRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newEducationSchool);
    }

    @Override
    public IEducationSchoolCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IEducationSchoolCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public IEducationSchoolCollectionRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }

    @Override
    public IEducationSchoolCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IEducationSchoolCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IEducationSchoolCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IEducationSchoolCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IEducationSchoolCollectionPage buildFromResponse(EducationSchoolCollectionResponse response) {
        EducationSchoolCollectionRequestBuilder builder = response.nextLink != null ? new EducationSchoolCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        EducationSchoolCollectionPage page = new EducationSchoolCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

