/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.extensions.Extension;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IExtensionRequest;
import java.util.List;

public class ExtensionRequest
extends BaseRequest
implements IExtensionRequest {
    public ExtensionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions, Class<? extends Extension> responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    public ExtensionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, Extension.class);
    }

    @Override
    public void get(ICallback<? super Extension> callback) {
        this.send(HttpMethod.GET, callback, null);
    }

    @Override
    public Extension get() throws ClientException {
        return (Extension)this.send(HttpMethod.GET, null);
    }

    @Override
    public void delete(ICallback<? super Extension> callback) {
        this.send(HttpMethod.DELETE, callback, null);
    }

    @Override
    public void delete() throws ClientException {
        this.send(HttpMethod.DELETE, null);
    }

    @Override
    public void patch(Extension sourceExtension, ICallback<? super Extension> callback) {
        this.send(HttpMethod.PATCH, callback, sourceExtension);
    }

    @Override
    public Extension patch(Extension sourceExtension) throws ClientException {
        return (Extension)this.send(HttpMethod.PATCH, sourceExtension);
    }

    @Override
    public void post(Extension newExtension, ICallback<? super Extension> callback) {
        this.send(HttpMethod.POST, callback, newExtension);
    }

    @Override
    public Extension post(Extension newExtension) throws ClientException {
        return (Extension)this.send(HttpMethod.POST, newExtension);
    }

    @Override
    public void put(Extension newExtension, ICallback<? super Extension> callback) {
        this.send(HttpMethod.PUT, callback, newExtension);
    }

    @Override
    public Extension put(Extension newExtension) throws ClientException {
        return (Extension)this.send(HttpMethod.PUT, newExtension);
    }

    @Override
    public IExtensionRequest select(String value) {
        this.getQueryOptions().add(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IExtensionRequest expand(String value) {
        this.getQueryOptions().add(new QueryOption("$expand", value));
        return this;
    }
}

