/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.core.BaseActionRequestBuilder;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.extensions.IManagedDeviceWipeRequest;
import com.microsoft.graph.requests.extensions.IManagedDeviceWipeRequestBuilder;
import com.microsoft.graph.requests.extensions.ManagedDeviceWipeRequest;
import java.util.List;

public class ManagedDeviceWipeRequestBuilder
extends BaseActionRequestBuilder
implements IManagedDeviceWipeRequestBuilder {
    public ManagedDeviceWipeRequestBuilder(String requestUrl, IBaseClient client, List<? extends Option> requestOptions, Boolean keepEnrollmentData, Boolean keepUserData, String macOsUnlockCode) {
        super(requestUrl, client, requestOptions);
        this.bodyParams.put("keepEnrollmentData", keepEnrollmentData);
        this.bodyParams.put("keepUserData", keepUserData);
        this.bodyParams.put("macOsUnlockCode", macOsUnlockCode);
    }

    @Override
    public IManagedDeviceWipeRequest buildRequest(Option ... requestOptions) {
        return this.buildRequest(this.getOptions(requestOptions));
    }

    @Override
    public IManagedDeviceWipeRequest buildRequest(List<? extends Option> requestOptions) {
        ManagedDeviceWipeRequest request = new ManagedDeviceWipeRequest(this.getRequestUrl(), this.getClient(), requestOptions);
        if (this.hasParameter("keepEnrollmentData")) {
            request.body.keepEnrollmentData = (Boolean)this.getParameter("keepEnrollmentData");
        }
        if (this.hasParameter("keepUserData")) {
            request.body.keepUserData = (Boolean)this.getParameter("keepUserData");
        }
        if (this.hasParameter("macOsUnlockCode")) {
            request.body.macOsUnlockCode = (String)this.getParameter("macOsUnlockCode");
        }
        return request;
    }
}

