/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.TermsAndConditionsAssignment;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.ITermsAndConditionsAssignmentCollectionPage;
import com.microsoft.graph.requests.extensions.ITermsAndConditionsAssignmentCollectionRequest;
import com.microsoft.graph.requests.extensions.TermsAndConditionsAssignmentCollectionPage;
import com.microsoft.graph.requests.extensions.TermsAndConditionsAssignmentCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.TermsAndConditionsAssignmentCollectionResponse;
import com.microsoft.graph.requests.extensions.TermsAndConditionsAssignmentRequestBuilder;
import java.util.List;

public class TermsAndConditionsAssignmentCollectionRequest
extends BaseCollectionRequest<TermsAndConditionsAssignmentCollectionResponse, ITermsAndConditionsAssignmentCollectionPage>
implements ITermsAndConditionsAssignmentCollectionRequest {
    public TermsAndConditionsAssignmentCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, TermsAndConditionsAssignmentCollectionResponse.class, ITermsAndConditionsAssignmentCollectionPage.class);
    }

    @Override
    public void get(final ICallback<? super ITermsAndConditionsAssignmentCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(TermsAndConditionsAssignmentCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public ITermsAndConditionsAssignmentCollectionPage get() throws ClientException {
        TermsAndConditionsAssignmentCollectionResponse response = (TermsAndConditionsAssignmentCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(TermsAndConditionsAssignment newTermsAndConditionsAssignment, ICallback<? super TermsAndConditionsAssignment> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new TermsAndConditionsAssignmentRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newTermsAndConditionsAssignment, callback);
    }

    @Override
    public TermsAndConditionsAssignment post(TermsAndConditionsAssignment newTermsAndConditionsAssignment) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new TermsAndConditionsAssignmentRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newTermsAndConditionsAssignment);
    }

    @Override
    public ITermsAndConditionsAssignmentCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public ITermsAndConditionsAssignmentCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public ITermsAndConditionsAssignmentCollectionRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }

    @Override
    public ITermsAndConditionsAssignmentCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public ITermsAndConditionsAssignmentCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public ITermsAndConditionsAssignmentCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public ITermsAndConditionsAssignmentCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public ITermsAndConditionsAssignmentCollectionPage buildFromResponse(TermsAndConditionsAssignmentCollectionResponse response) {
        TermsAndConditionsAssignmentCollectionRequestBuilder builder = response.nextLink != null ? new TermsAndConditionsAssignmentCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        TermsAndConditionsAssignmentCollectionPage page = new TermsAndConditionsAssignmentCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

