// Template Source: IBaseEntityWithReferenceRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.EducationSchool;
import com.microsoft.graph.requests.extensions.IEducationClassCollectionWithReferencesRequestBuilder;
import com.microsoft.graph.requests.extensions.IEducationClassWithReferenceRequestBuilder;
import com.microsoft.graph.requests.extensions.IEducationUserCollectionWithReferencesRequestBuilder;
import com.microsoft.graph.requests.extensions.IEducationUserWithReferenceRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;

import com.microsoft.graph.models.extensions.EducationSchool;
import com.microsoft.graph.http.IHttpRequest;
import com.microsoft.graph.serializer.IJsonBackedObject;


// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Education School With Reference Request.
 */
public interface IEducationSchoolWithReferenceRequest extends IHttpRequest {

    void post(final EducationSchool newEducationSchool, final IJsonBackedObject payload, final ICallback<? super EducationSchool> callback);

    EducationSchool post(final EducationSchool newEducationSchool, final IJsonBackedObject payload) throws ClientException;

    void get(final ICallback<? super EducationSchool> callback);

    EducationSchool get() throws ClientException;

	void delete(final ICallback<? super EducationSchool> callback);

	void delete() throws ClientException;

	void patch(final EducationSchool sourceEducationSchool, final ICallback<? super EducationSchool> callback);

	EducationSchool patch(final EducationSchool sourceEducationSchool) throws ClientException;

    IEducationSchoolWithReferenceRequest select(final String value);

    IEducationSchoolWithReferenceRequest expand(final String value);

}
