// Template Source: IBaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.InferenceClassificationOverride;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Inference Classification Override Request.
 */
public interface IInferenceClassificationOverrideRequest extends IHttpRequest {

    /**
     * Gets the InferenceClassificationOverride from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<? super InferenceClassificationOverride> callback);

    /**
     * Gets the InferenceClassificationOverride from the service
     *
     * @return the InferenceClassificationOverride from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    InferenceClassificationOverride get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<? super InferenceClassificationOverride> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this InferenceClassificationOverride with a source
     *
     * @param sourceInferenceClassificationOverride the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final InferenceClassificationOverride sourceInferenceClassificationOverride, final ICallback<? super InferenceClassificationOverride> callback);

    /**
     * Patches this InferenceClassificationOverride with a source
     *
     * @param sourceInferenceClassificationOverride the source object with updates
     * @return the updated InferenceClassificationOverride
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    InferenceClassificationOverride patch(final InferenceClassificationOverride sourceInferenceClassificationOverride) throws ClientException;

    /**
     * Posts a InferenceClassificationOverride with a new object
     *
     * @param newInferenceClassificationOverride the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final InferenceClassificationOverride newInferenceClassificationOverride, final ICallback<? super InferenceClassificationOverride> callback);

    /**
     * Posts a InferenceClassificationOverride with a new object
     *
     * @param newInferenceClassificationOverride the new object to create
     * @return the created InferenceClassificationOverride
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    InferenceClassificationOverride post(final InferenceClassificationOverride newInferenceClassificationOverride) throws ClientException;

    /**
     * Posts a InferenceClassificationOverride with a new object
     *
     * @param newInferenceClassificationOverride the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final InferenceClassificationOverride newInferenceClassificationOverride, final ICallback<? super InferenceClassificationOverride> callback);

    /**
     * Posts a InferenceClassificationOverride with a new object
     *
     * @param newInferenceClassificationOverride the object to create/update
     * @return the created InferenceClassificationOverride
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    InferenceClassificationOverride put(final InferenceClassificationOverride newInferenceClassificationOverride) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IInferenceClassificationOverrideRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IInferenceClassificationOverrideRequest expand(final String value);

}

