// Template Source: IBaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.IosUpdateConfiguration;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Ios Update Configuration Request.
 */
public interface IIosUpdateConfigurationRequest extends IHttpRequest {

    /**
     * Gets the IosUpdateConfiguration from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<? super IosUpdateConfiguration> callback);

    /**
     * Gets the IosUpdateConfiguration from the service
     *
     * @return the IosUpdateConfiguration from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    IosUpdateConfiguration get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<? super IosUpdateConfiguration> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this IosUpdateConfiguration with a source
     *
     * @param sourceIosUpdateConfiguration the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final IosUpdateConfiguration sourceIosUpdateConfiguration, final ICallback<? super IosUpdateConfiguration> callback);

    /**
     * Patches this IosUpdateConfiguration with a source
     *
     * @param sourceIosUpdateConfiguration the source object with updates
     * @return the updated IosUpdateConfiguration
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    IosUpdateConfiguration patch(final IosUpdateConfiguration sourceIosUpdateConfiguration) throws ClientException;

    /**
     * Posts a IosUpdateConfiguration with a new object
     *
     * @param newIosUpdateConfiguration the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final IosUpdateConfiguration newIosUpdateConfiguration, final ICallback<? super IosUpdateConfiguration> callback);

    /**
     * Posts a IosUpdateConfiguration with a new object
     *
     * @param newIosUpdateConfiguration the new object to create
     * @return the created IosUpdateConfiguration
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    IosUpdateConfiguration post(final IosUpdateConfiguration newIosUpdateConfiguration) throws ClientException;

    /**
     * Posts a IosUpdateConfiguration with a new object
     *
     * @param newIosUpdateConfiguration the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final IosUpdateConfiguration newIosUpdateConfiguration, final ICallback<? super IosUpdateConfiguration> callback);

    /**
     * Posts a IosUpdateConfiguration with a new object
     *
     * @param newIosUpdateConfiguration the object to create/update
     * @return the created IosUpdateConfiguration
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    IosUpdateConfiguration put(final IosUpdateConfiguration newIosUpdateConfiguration) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IIosUpdateConfigurationRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IIosUpdateConfigurationRequest expand(final String value);

}

