// Template Source: IBaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.TermsAndConditions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Terms And Conditions Request.
 */
public interface ITermsAndConditionsRequest extends IHttpRequest {

    /**
     * Gets the TermsAndConditions from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<? super TermsAndConditions> callback);

    /**
     * Gets the TermsAndConditions from the service
     *
     * @return the TermsAndConditions from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    TermsAndConditions get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<? super TermsAndConditions> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this TermsAndConditions with a source
     *
     * @param sourceTermsAndConditions the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final TermsAndConditions sourceTermsAndConditions, final ICallback<? super TermsAndConditions> callback);

    /**
     * Patches this TermsAndConditions with a source
     *
     * @param sourceTermsAndConditions the source object with updates
     * @return the updated TermsAndConditions
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    TermsAndConditions patch(final TermsAndConditions sourceTermsAndConditions) throws ClientException;

    /**
     * Posts a TermsAndConditions with a new object
     *
     * @param newTermsAndConditions the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final TermsAndConditions newTermsAndConditions, final ICallback<? super TermsAndConditions> callback);

    /**
     * Posts a TermsAndConditions with a new object
     *
     * @param newTermsAndConditions the new object to create
     * @return the created TermsAndConditions
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    TermsAndConditions post(final TermsAndConditions newTermsAndConditions) throws ClientException;

    /**
     * Posts a TermsAndConditions with a new object
     *
     * @param newTermsAndConditions the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final TermsAndConditions newTermsAndConditions, final ICallback<? super TermsAndConditions> callback);

    /**
     * Posts a TermsAndConditions with a new object
     *
     * @param newTermsAndConditions the object to create/update
     * @return the created TermsAndConditions
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    TermsAndConditions put(final TermsAndConditions newTermsAndConditions) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    ITermsAndConditionsRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    ITermsAndConditionsRequest expand(final String value);

}

