// Template Source: IBaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.UrlAssessmentRequest;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Url Assessment Request Request.
 */
public interface IUrlAssessmentRequestRequest extends IHttpRequest {

    /**
     * Gets the UrlAssessmentRequest from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<? super UrlAssessmentRequest> callback);

    /**
     * Gets the UrlAssessmentRequest from the service
     *
     * @return the UrlAssessmentRequest from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    UrlAssessmentRequest get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<? super UrlAssessmentRequest> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this UrlAssessmentRequest with a source
     *
     * @param sourceUrlAssessmentRequest the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final UrlAssessmentRequest sourceUrlAssessmentRequest, final ICallback<? super UrlAssessmentRequest> callback);

    /**
     * Patches this UrlAssessmentRequest with a source
     *
     * @param sourceUrlAssessmentRequest the source object with updates
     * @return the updated UrlAssessmentRequest
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    UrlAssessmentRequest patch(final UrlAssessmentRequest sourceUrlAssessmentRequest) throws ClientException;

    /**
     * Posts a UrlAssessmentRequest with a new object
     *
     * @param newUrlAssessmentRequest the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final UrlAssessmentRequest newUrlAssessmentRequest, final ICallback<? super UrlAssessmentRequest> callback);

    /**
     * Posts a UrlAssessmentRequest with a new object
     *
     * @param newUrlAssessmentRequest the new object to create
     * @return the created UrlAssessmentRequest
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    UrlAssessmentRequest post(final UrlAssessmentRequest newUrlAssessmentRequest) throws ClientException;

    /**
     * Posts a UrlAssessmentRequest with a new object
     *
     * @param newUrlAssessmentRequest the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final UrlAssessmentRequest newUrlAssessmentRequest, final ICallback<? super UrlAssessmentRequest> callback);

    /**
     * Posts a UrlAssessmentRequest with a new object
     *
     * @param newUrlAssessmentRequest the object to create/update
     * @return the created UrlAssessmentRequest
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    UrlAssessmentRequest put(final UrlAssessmentRequest newUrlAssessmentRequest) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IUrlAssessmentRequestRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IUrlAssessmentRequestRequest expand(final String value);

}

