// Template Source: IBaseEntityRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.WorkbookTable;
import com.microsoft.graph.models.extensions.WorkbookRange;
import com.microsoft.graph.requests.extensions.IWorkbookTableColumnCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IWorkbookTableColumnRequestBuilder;
import com.microsoft.graph.requests.extensions.IWorkbookTableRowCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IWorkbookTableRowRequestBuilder;
import com.microsoft.graph.requests.extensions.IWorkbookTableSortRequestBuilder;
import com.microsoft.graph.requests.extensions.IWorkbookWorksheetRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Workbook Table Request Builder.
 */
public interface IWorkbookTableRequestBuilder extends IRequestBuilder {
    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the IWorkbookTableRequest instance
     */
    IWorkbookTableRequest buildRequest(final com.microsoft.graph.options.Option... requestOptions);

    /**
     * Creates the request with specific options instead of the existing options
     *
     * @param requestOptions the options for this request
     * @return the IWorkbookTableRequest instance
     */
    IWorkbookTableRequest buildRequest(final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions);


    IWorkbookTableColumnCollectionRequestBuilder columns();

    IWorkbookTableColumnRequestBuilder columns(final String id);

    IWorkbookTableRowCollectionRequestBuilder rows();

    IWorkbookTableRowRequestBuilder rows(final String id);

    /**
     * Gets the request builder for WorkbookTableSort
     *
     * @return the IWorkbookTableSortRequestBuilder instance
     */
    IWorkbookTableSortRequestBuilder sort();

    /**
     * Gets the request builder for WorkbookWorksheet
     *
     * @return the IWorkbookWorksheetRequestBuilder instance
     */
    IWorkbookWorksheetRequestBuilder worksheet();
    IWorkbookTableClearFiltersRequestBuilder clearFilters();
    IWorkbookTableConvertToRangeRequestBuilder convertToRange();
    IWorkbookTableReapplyFiltersRequestBuilder reapplyFilters();
    IWorkbookTableDataBodyRangeRequestBuilder dataBodyRange();
    IWorkbookTableHeaderRowRangeRequestBuilder headerRowRange();
    IWorkbookTableRangeRequestBuilder range();
    IWorkbookTableTotalRowRangeRequestBuilder totalRowRange();

}