// Template Source: BaseMethodRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.requests.extensions.IWorkbookNamedItemAddFormulaLocalRequest;
import com.microsoft.graph.requests.extensions.WorkbookNamedItemAddFormulaLocalRequest;
import com.microsoft.graph.models.extensions.WorkbookNamedItem;
import com.microsoft.graph.core.BaseActionRequestBuilder;
import com.microsoft.graph.core.BaseFunctionRequestBuilder;
import com.microsoft.graph.core.IBaseClient;
import com.google.gson.JsonElement;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workbook Named Item Add Formula Local Request Builder.
 */
public class WorkbookNamedItemAddFormulaLocalRequestBuilder extends BaseActionRequestBuilder implements IWorkbookNamedItemAddFormulaLocalRequestBuilder {

    /**
     * The request builder for this WorkbookNamedItemAddFormulaLocal
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param name the name
     * @param formula the formula
     * @param comment the comment
     */
    public WorkbookNamedItemAddFormulaLocalRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions, final String name, final String formula, final String comment) {
        super(requestUrl, client, requestOptions);
        bodyParams.put("name", name);
        bodyParams.put("formula", formula);
        bodyParams.put("comment", comment);
    }

    /**
     * Creates the IWorkbookNamedItemAddFormulaLocalRequest
     *
     * @param requestOptions the options for the request
     * @return the IWorkbookNamedItemAddFormulaLocalRequest instance
     */
    public IWorkbookNamedItemAddFormulaLocalRequest buildRequest(final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the IWorkbookNamedItemAddFormulaLocalRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return the IWorkbookNamedItemAddFormulaLocalRequest instance
     */
    public IWorkbookNamedItemAddFormulaLocalRequest buildRequest(final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        WorkbookNamedItemAddFormulaLocalRequest request = new WorkbookNamedItemAddFormulaLocalRequest(
                getRequestUrl(),
                getClient(),
                requestOptions
        );

        if (hasParameter("name")) {
            request.body.name = getParameter("name");
        }

        if (hasParameter("formula")) {
            request.body.formula = getParameter("formula");
        }

        if (hasParameter("comment")) {
            request.body.comment = getParameter("comment");
        }

        return request;
    }
}
