/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.AuthenticationMethod;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.AuthenticationMethodCollectionPage;
import com.microsoft.graph.requests.extensions.AuthenticationMethodCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.AuthenticationMethodCollectionResponse;
import com.microsoft.graph.requests.extensions.AuthenticationMethodRequestBuilder;
import com.microsoft.graph.requests.extensions.IAuthenticationMethodCollectionPage;
import com.microsoft.graph.requests.extensions.IAuthenticationMethodCollectionRequest;
import java.util.List;

public class AuthenticationMethodCollectionRequest
extends BaseCollectionRequest<AuthenticationMethodCollectionResponse, IAuthenticationMethodCollectionPage>
implements IAuthenticationMethodCollectionRequest {
    public AuthenticationMethodCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, AuthenticationMethodCollectionResponse.class, IAuthenticationMethodCollectionPage.class);
    }

    @Override
    public void get(final ICallback<? super IAuthenticationMethodCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(AuthenticationMethodCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IAuthenticationMethodCollectionPage get() throws ClientException {
        AuthenticationMethodCollectionResponse response = (AuthenticationMethodCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(AuthenticationMethod newAuthenticationMethod, ICallback<? super AuthenticationMethod> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new AuthenticationMethodRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newAuthenticationMethod, callback);
    }

    @Override
    public AuthenticationMethod post(AuthenticationMethod newAuthenticationMethod) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new AuthenticationMethodRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newAuthenticationMethod);
    }

    @Override
    public IAuthenticationMethodCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IAuthenticationMethodCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public IAuthenticationMethodCollectionRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }

    @Override
    public IAuthenticationMethodCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IAuthenticationMethodCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IAuthenticationMethodCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IAuthenticationMethodCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IAuthenticationMethodCollectionPage buildFromResponse(AuthenticationMethodCollectionResponse response) {
        AuthenticationMethodCollectionRequestBuilder builder = response.nextLink != null ? new AuthenticationMethodCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        AuthenticationMethodCollectionPage page = new AuthenticationMethodCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

