/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.http.ReferenceRequestBody;
import com.microsoft.graph.models.extensions.CertificateBasedAuthConfiguration;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.CertificateBasedAuthConfigurationCollectionResponse;
import com.microsoft.graph.requests.extensions.CertificateBasedAuthConfigurationWithReferenceRequestBuilder;
import com.microsoft.graph.requests.extensions.ICertificateBasedAuthConfigurationCollectionPage;
import com.microsoft.graph.requests.extensions.ICertificateBasedAuthConfigurationCollectionReferenceRequest;
import java.util.List;

public class CertificateBasedAuthConfigurationCollectionReferenceRequest
extends BaseCollectionRequest<CertificateBasedAuthConfigurationCollectionResponse, ICertificateBasedAuthConfigurationCollectionPage>
implements ICertificateBasedAuthConfigurationCollectionReferenceRequest {
    public CertificateBasedAuthConfigurationCollectionReferenceRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, CertificateBasedAuthConfigurationCollectionResponse.class, ICertificateBasedAuthConfigurationCollectionPage.class);
    }

    @Override
    public void post(CertificateBasedAuthConfiguration newCertificateBasedAuthConfiguration, ICallback<? super CertificateBasedAuthConfiguration> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        ReferenceRequestBody body = new ReferenceRequestBody(this.getBaseRequest().getClient().getServiceRoot() + "/certificateBasedAuthConfiguration/" + newCertificateBasedAuthConfiguration.id);
        new CertificateBasedAuthConfigurationWithReferenceRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newCertificateBasedAuthConfiguration, body, callback);
    }

    @Override
    public CertificateBasedAuthConfiguration post(CertificateBasedAuthConfiguration newCertificateBasedAuthConfiguration) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        ReferenceRequestBody body = new ReferenceRequestBody(this.getBaseRequest().getClient().getServiceRoot() + "/certificateBasedAuthConfiguration/" + newCertificateBasedAuthConfiguration.id);
        return new CertificateBasedAuthConfigurationWithReferenceRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newCertificateBasedAuthConfiguration, body);
    }

    public ICertificateBasedAuthConfigurationCollectionReferenceRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    public ICertificateBasedAuthConfigurationCollectionReferenceRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    public ICertificateBasedAuthConfigurationCollectionReferenceRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }

    @Override
    public ICertificateBasedAuthConfigurationCollectionReferenceRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public ICertificateBasedAuthConfigurationCollectionReferenceRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }
}

