/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.ChatGetAllMessagesCollectionPage;
import com.microsoft.graph.requests.extensions.ChatGetAllMessagesCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.ChatGetAllMessagesCollectionResponse;
import com.microsoft.graph.requests.extensions.IChatGetAllMessagesCollectionPage;
import com.microsoft.graph.requests.extensions.IChatGetAllMessagesCollectionRequest;
import java.util.List;

public class ChatGetAllMessagesCollectionRequest
extends BaseCollectionRequest<ChatGetAllMessagesCollectionResponse, IChatGetAllMessagesCollectionPage>
implements IChatGetAllMessagesCollectionRequest {
    public ChatGetAllMessagesCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ChatGetAllMessagesCollectionResponse.class, IChatGetAllMessagesCollectionPage.class);
    }

    @Override
    public void get(final ICallback<? super IChatGetAllMessagesCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(ChatGetAllMessagesCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IChatGetAllMessagesCollectionPage get() throws ClientException {
        ChatGetAllMessagesCollectionResponse response = (ChatGetAllMessagesCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    public IChatGetAllMessagesCollectionPage buildFromResponse(ChatGetAllMessagesCollectionResponse response) {
        ChatGetAllMessagesCollectionRequestBuilder builder = response.nextLink != null ? new ChatGetAllMessagesCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        ChatGetAllMessagesCollectionPage page = new ChatGetAllMessagesCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }

    @Override
    public IChatGetAllMessagesCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IChatGetAllMessagesCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IChatGetAllMessagesCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    public IChatGetAllMessagesCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    public IChatGetAllMessagesCollectionRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }
}

