/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.extensions.ColumnLink;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IColumnLinkRequest;
import java.util.List;

public class ColumnLinkRequest
extends BaseRequest
implements IColumnLinkRequest {
    public ColumnLinkRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ColumnLink.class);
    }

    @Override
    public void get(ICallback<? super ColumnLink> callback) {
        this.send(HttpMethod.GET, callback, null);
    }

    @Override
    public ColumnLink get() throws ClientException {
        return (ColumnLink)this.send(HttpMethod.GET, null);
    }

    @Override
    public void delete(ICallback<? super ColumnLink> callback) {
        this.send(HttpMethod.DELETE, callback, null);
    }

    @Override
    public void delete() throws ClientException {
        this.send(HttpMethod.DELETE, null);
    }

    @Override
    public void patch(ColumnLink sourceColumnLink, ICallback<? super ColumnLink> callback) {
        this.send(HttpMethod.PATCH, callback, sourceColumnLink);
    }

    @Override
    public ColumnLink patch(ColumnLink sourceColumnLink) throws ClientException {
        return (ColumnLink)this.send(HttpMethod.PATCH, sourceColumnLink);
    }

    @Override
    public void post(ColumnLink newColumnLink, ICallback<? super ColumnLink> callback) {
        this.send(HttpMethod.POST, callback, newColumnLink);
    }

    @Override
    public ColumnLink post(ColumnLink newColumnLink) throws ClientException {
        return (ColumnLink)this.send(HttpMethod.POST, newColumnLink);
    }

    @Override
    public void put(ColumnLink newColumnLink, ICallback<? super ColumnLink> callback) {
        this.send(HttpMethod.PUT, callback, newColumnLink);
    }

    @Override
    public ColumnLink put(ColumnLink newColumnLink) throws ClientException {
        return (ColumnLink)this.send(HttpMethod.PUT, newColumnLink);
    }

    @Override
    public IColumnLinkRequest select(String value) {
        this.getQueryOptions().add(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IColumnLinkRequest expand(String value) {
        this.getQueryOptions().add(new QueryOption("$expand", value));
        return this;
    }
}

